<!DOCTYPE html>
<html lang="en">
<!--begin::Head-->
<head>
    <base href="../../../"/>
    <title>ورود | A38</title>
    <meta charset="utf-8"/>
    <base href="<?php echo $_ENV["BASE_URL"] ?>" >
    <meta name="description"
          content="The most advanced Bootstrap 5 Admin Theme with 40 unique prebuilt layouts on Themeforest trusted by 100,000 beginners and professionals. Multi-demo, Dark Mode, RTL support and complete React, Angular, Vue, Asp.Net Core, Rails, Spring, Blazor, Django, Express.js, Node.js, Flask, Symfony & Laravel versions. Grab your copy now and get life-time updates for free."/>
    <meta name="keywords"
          content="metronic, bootstrap, bootstrap 5, angular, VueJs, React, Asp.Net Core, Rails, Spring, Blazor, Django, Express.js, Node.js, Flask, Symfony & Laravel starter kits, admin themes, web design, figma, web development, free templates, free admin themes, bootstrap theme, bootstrap template, bootstrap dashboard, bootstrap dak mode, bootstrap button, bootstrap datepicker, bootstrap timepicker, fullcalendar, datatables, flaticon"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <meta property="og:locale" content="en_US"/>
    <meta property="og:type" content="article"/>
    <meta property="og:title" content="Metronic - The World's #1 Selling Bootstrap Admin Template by KeenThemes"/>
    <meta property="og:url" content="https://keenthemes.com/metronic"/>
    <meta property="og:site_name" content="Metronic by Keenthemes"/>
    <link rel="canonical" href="http://preview.keenthemes.comauthentication/layouts/creative/sign-in.html"/>
    <link rel="shortcut icon" href="assets/media/my_media/logo.png"/>
    <!--begin::Fonts(mandatory for all pages)-->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700"/>
    <link rel="stylesheet" href="assets/fonts/Vazirmatn-font-face.css">
    <!--end::Fonts-->
    <!--begin::Global Stylesheets Bundle(mandatory for all pages)-->
    <link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="assets/css/style.bundle.css" rel="stylesheet" type="text/css"/>
    <!--end::Global Stylesheets Bundle-->
    <script>// Frame-busting to prevent site from being loaded within a frame without permission (click-jacking) if (window.top != window.self) { window.top.location.replace(window.self.location.href); }</script>
</head>
<style>
    body {
         font-family: 'Vazirmatn', sans-serif;
    }

    #input_password::placeholder {
        text-align: center;
    }

    #input_number::placeholder {
        text-align: center;
    }
</style>
<!--end::Head-->
<!--begin::Body-->
<body id="kt_body" class="app-blank bgi-size-cover bgi-attachment-fixed bgi-position-center bgi-no-repeat">
<!--begin::Theme mode setup on page load-->
<script>var defaultThemeMode = "light";
    var themeMode;
    if (document.documentElement) {
        if (document.documentElement.hasAttribute("data-bs-theme-mode")) {
            themeMode = document.documentElement.getAttribute("data-bs-theme-mode");
        } else {
            if (localStorage.getItem("data-bs-theme") !== null) {
                themeMode = localStorage.getItem("data-bs-theme");
            } else {
                themeMode = defaultThemeMode;
            }
        }
        if (themeMode === "system") {
            themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light";
        }
        document.documentElement.setAttribute("data-bs-theme", themeMode);
    }</script>
<!--end::Theme mode setup on page load-->
<!--begin::Root-->
<div class="d-flex flex-column flex-root" id="kt_app_root">
    <!--begin::Page bg image-->
    <style>body {
            background-image: url('assets/media/auth/bg5-dark.jpg');
        }

        [data-bs-theme="dark"] body {
            background-image: url('assets/media/auth/bg5-dark.jpg');
        }</style>
    <!--end::Page bg image-->
    <!--begin::Authentication - Sign-in -->
    <div class="d-flex flex-column flex-column-fluid flex-lg-row">
        <!--begin::Aside-->
        <div class="d-flex flex-center w-lg-50 pt-15 pt-lg-0 px-10">
            <!--begin::Aside-->
            <div class="d-flex flex-center flex-lg-start flex-column" style="margin-left: 15% ; margin-top: -6% ;">
                <!--begin::Logo-->
                <a href="" class="" >
                    <img alt="Logo" style="height: auto ; width: 80%" src="assets/media/my_media/logo.png"/>
                </a>
                <!--end::Logo-->
<!--                <h2 class="text-white fs-3hx fw-bold justify-content-center text-center " style="margin-top: -12px ;"> CUSTOMER <br> SERVICES </h2>-->
            </div>
            <!--begin::Aside-->
        </div>
        <!--begin::Aside-->
        <!--begin::Body-->
        <div class="d-flex flex-column-fluid align-center flex-lg-row-auto justify-content-center justify-content-lg-end p-12 p-lg-20">
            <!--begin::Card-->
            <div class="bg-body d-flex flex-column align-items-stretch flex-center rounded-4 align-center h-md-550px w-md-600px p-20"
                 style="height: 600px; margin-top: 70px ">
                <!--begin::Wrapper-->
                <div class="d-flex flex-center flex-column flex-column-fluid px-lg-10 pb-15 pb-lg-10">
                    <!--begin::Form-->
                    <form class="form w-100" novalidate="novalidate" id="login_form"
                          data-kt-redirect-url="index.html">
                        <!--begin::Heading-->
                        <div class="text-center mb-11">
                            <!--begin::Title-->
                            <h1 class="text-gray-900 fw-bolder mb-3">ورود</h1>
                            <!--end::Title-->
                            <!--begin::Subtitle-->
                            <div class="text-gray-500 fw-semibold fs-6">سامانه مدیریت سایت A38</div>
                            <!--end::Subtitle=-->
                        </div>
                        <!--begin::Heading-->
                        <!--begin::Input group=-->
                        <div class="fv-row mb-8">
                            <!--begin::Email-->
                            <input type="text" id="input_number" placeholder="شماره موبایل" name="personalNumber"
                                   autocomplete="off" class="form-control bg-transparent"/>
                            <!--end::Email-->
                        </div>
                        <!--end::Input group=-->
                        <div class="fv-row mb-3">
                            <!--begin::Password-->
                            <input type="password" id="input_password" placeholder="رمز عبور" name="password"
                                   autocomplete="off" class="form-control bg-transparent"/>
                            <!--end::Password-->
                        </div>
                        <!--end::Input group=-->
                        <!--begin::Wrapper-->
                        <div class="d-flex flex-stack justify-content-start flex-wrap gap-3 fs-base fw-semibold mb-8">
                            <div></div>
                            <!--begin::Link-->
                            <a onclick="reset_password()" class="link-primary">رمزتان را
                                فراموش کرده اید ؟</a>
                            <!--end::Link-->
                        </div>
                        <!--end::Wrapper-->
                        <!--begin::Submit button-->
                        <div class="d-grid mb-10">
                            <button type="submit"  class="btn btn-primary">
                                <!--begin::Indicator label-->
                                <span class="indicator-label">ورود</span>
                                <!--end::Indicator label-->
                                <!--begin::Indicator progress-->
                                <span class="indicator-progress">لطفا صبر کنید ...
										<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                                <!--end::Indicator progress-->
                            </button>
                        </div>
                        <!--end::Submit button-->
                    </form>
                    <!--end::Form-->
                </div>
                <!--end::Wrapper-->
            </div>
            <!--end::Card-->
        </div>
        <!--end::Body-->
    </div>
    <!--end::Authentication - Sign-in-->
</div>
<!--end::Root-->
<!--begin::Javascript-->
<script>var hostUrl = "assets/";</script>
<!--begin::Global Javascript Bundle(mandatory for all pages)-->
<script src="assets/plugins/global/plugins.bundle.js"></script>
<script>
    const BASE_URL = <?PHP echo $_ENV["BASE_URL"] ?> ;
</script>
<script src="assets/js/scripts.bundle.js"></script>
<!--end::Global Javascript Bundle-->
<!--begin::Custom Javascript(used for this page only)-->
<!--<script src="assets/js/custom/authentication/sign-in/general.js"></script>-->
<script src="assets/js/myjs/ApiClient.js"></script>
<script>
    const api = new ApiClient();
    var r;  // متغیری برای نگهداری اعتبارسنجی فرم

    function setupFormValidation() {
        let t = document.querySelector("#login_form");

        r = FormValidation.formValidation(t, {
            fields: {
                personalNumber: {
                    validators: {
                        notEmpty: {
                            message: "لطفا نام کاربری خود را وارد کنید"
                        },
                    }
                },
                password: {
                    validators: {
                        notEmpty: {
                            message: "لطفا رمز خود را وارد کنید"
                        }
                    }
                }
            },
            plugins: {
                trigger: new FormValidation.plugins.Trigger(),
                bootstrap: new FormValidation.plugins.Bootstrap5({
                    rowSelector: ".fv-row",
                    eleInvalidClass: "",
                    eleValidClass: ""
                })
            }
        });
    }

    function login(event) {
        event.preventDefault(); // جلوگیری از رفرش شدن صفحه

        // بررسی اعتبارسنجی فرم
        r.validate().then(function(status) {
            if (status === 'Valid') {
                // فرم معتبر است، ارسال درخواست به API
                let personalNumber = document.querySelector("#input_number").value;
                let password = document.querySelector("#input_password").value;

                let data = {
                    "phone": personalNumber,
                    "password": password
                };

                // ارسال درخواست به API
                api.post('/api/admin/login', data)
                    .then(response => {
                        console.log(response);
                        if (response.message === "Success") {
                                console.log(response.data);
                                window.location.href = "/adminshop/dashboard";
                        } else {
                            // نمایش پیام خطا بر اساس پاسخ API
                            Swal.fire({
                                text: response.message,
                                icon: "error",
                                confirmButtonText: "باشه!"
                            });
                        }
                    })
                    .catch(error => {
                        console.error('Error during login:', error);
                        Swal.fire({
                            text: "مشکلی در ارتباط با سرور وجود دارد، لطفا دوباره تلاش کنید.",
                            icon: "error",
                            confirmButtonText: "باشه!"
                        });
                    });
            } else {
                // فرم معتبر نیست، نمایش پیام خطا
                Swal.fire({
                    text: "لطفا فیلدهای مورد نیاز را به درستی پر کنید.",
                    icon: "error",
                    confirmButtonText: "باشه!"
                });
            }
        });
    }

    // افزودن Event Listener برای کلیک روی دکمه ورود
    document.addEventListener('DOMContentLoaded', function() {
        setupFormValidation();
        document.querySelector("#login_form").addEventListener("submit", login);
    });
    function reset_password() {
        codemelli = document.querySelector("#input_number").value ;
        data = {
            "codemelli" : codemelli,
        };
        api.post("/api/sms/send",data).then(
            response => {
                console.log(response)
                if (response.message === "Success"){
                    Swal.fire({
                        text: "کد اعتبار سنجی برای شما پیامک شد",
                        icon: "success",
                        confirmButtonText: "تایید"
                    }).then(() => {
                        window.location.href = "/two-factor?codemelli="+codemelli;
                    });
                }else{
                    Swal.fire({
                        text: response.message,
                        icon: "error",
                        confirmButtonText: "باشه!"
                    });
                }
            }
        ).catch(error=>{
            Swal.fire({
                text: "مشکلی در ارتباط با سرور وجود دارد، لطفا دوباره تلاش کنید.",
                icon: "error",
                confirmButtonText: "باشه!"
            });
        })
    }

</script>
<!--end::Custom Javascript-->
<!--end::Javascript-->
</body>
<!--end::Body-->

</html>