<!DOCTYPE html>
<html direction="rtl" dir="rtl" style="direction: rtl">
<!--begin::Head-->
<head>
    <title>محصولات | A38</title>
    <meta charset="utf-8"/>
    <base href="<?php echo $_ENV["BASE_URL"] ?>" >
    <meta name="description"
          content="The most advanced Bootstrap 5 Admin Theme with 40 unique prebuilt layouts on Themeforest trusted by 100,000 beginners and professionals. Multi-demo, Dark Mode, RTL support and complete React, Angular, Vue, Asp.Net Core, Rails, Spring, Blazor, Django, Express.js, Node.js, Flask, Symfony & Laravel versions. Grab your copy now and get life-time updates for free."/>
    <meta name="keywords"
          content="metronic, bootstrap, bootstrap 5, angular, VueJs, React, Asp.Net Core, Rails, Spring, Blazor, Django, Express.js, Node.js, Flask, Symfony & Laravel starter kits, admin themes, web design, figma, web development, free templates, free admin themes, bootstrap theme, bootstrap template, bootstrap dashboard, bootstrap dak mode, bootstrap button, bootstrap datepicker, bootstrap timepicker, fullcalendar, datatables, flaticon"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <meta property="og:locale" content="en_US"/>
    <meta property="og:type" content="article"/>
    <meta property="og:title" content=" آک گارانتی"/>
    <meta property="og:url" content="https://keenthemes.com/metronic"/>
    <meta property="og:site_name" content="Metronic by Keenthemes"/>
    <link rel="canonical" href="http://preview.keenthemes.comindex.html"/>
    <link rel="shortcut icon" href="assets/media/my_media/logo.png"/>
    <!--begin::Fonts(mandatory for all pages)-->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700"/>
    <link rel="stylesheet" href="assets/fonts/Vazirmatn-font-face.css">
     
    <!--end::Fonts-->
    <!--begin::Vendor Stylesheets(used for this page only)-->
    <link href="assets/plugins/custom/fullcalendar/fullcalendar.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
    <!--end::Vendor Stylesheets-->
    <!--begin::Global Stylesheets Bundle(mandatory for all pages)-->
    <link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="assets/css/style.bundle.css" rel="stylesheet" type="text/css"/>
    <script>// Frame-busting to prevent site from being loaded within a frame without permission (click-jacking) if (window.top != window.self) { window.top.location.replace(window.self.location.href); }</script>
</head>
<style>
    body {
         font-family: 'Vazirmatn', sans-serif;
    }
</style>
<!--end::Head-->
<!--begin::Body-->
<body id="kt_app_body" data-kt-app-layout="dark-sidebar" data-kt-app-header-fixed="true"
      data-kt-app-sidebar-enabled="true" data-kt-app-sidebar-fixed="true" data-kt-app-sidebar-hoverable="true"
      data-kt-app-sidebar-push-header="true" data-kt-app-sidebar-push-toolbar="true"
      data-kt-app-sidebar-push-footer="true" data-kt-app-toolbar-enabled="true" class="app-default">
<!--begin::Theme mode setup on page load-->
<script>var defaultThemeMode = "light";
    var themeMode;
    if (document.documentElement) {
        if (document.documentElement.hasAttribute("data-bs-theme-mode")) {
            themeMode = document.documentElement.getAttribute("data-bs-theme-mode");
        } else {
            if (localStorage.getItem("data-bs-theme") !== null) {
                themeMode = localStorage.getItem("data-bs-theme");
            } else {
                themeMode = defaultThemeMode;
            }
        }
        if (themeMode === "system") {
            themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light";
        }
        document.documentElement.setAttribute("data-bs-theme", themeMode);
    }</script>
<!--end::Theme mode setup on page load-->
<!--begin::App-->
<div class="d-flex flex-column flex-root app-root" id="kt_app_root">
    <!--begin::Page-->
    <div class="app-page flex-column flex-column-fluid" id="kt_app_page">
        <!--begin::Header-->
        <div id="kt_app_header" class="app-header" data-kt-sticky="true"
             data-kt-sticky-activate="{default: true, lg: true}" data-kt-sticky-name="app-header-minimize"
             data-kt-sticky-offset="{default: '200px', lg: '0'}" data-kt-sticky-animation="false">
            <!--begin::Header container-->
            <div class="app-container container-fluid d-flex align-items-stretch justify-content-between"
                 id="kt_app_header_container">
                <!--begin::Sidebar mobile toggle-->
                <div class="d-flex align-items-center d-lg-none ms-n3 me-1 me-md-2" title="Show sidebar menu">
                    <div class="btn btn-icon btn-active-color-primary w-35px h-35px" id="kt_app_sidebar_mobile_toggle">
                        <i class="ki-duotone ki-abstract-14 fs-2 fs-md-1">
                            <span class="path1"></span>
                            <span class="path2"></span>
                        </i>
                    </div>
                </div>
                <!--end::Sidebar mobile toggle-->
                <!--begin::Mobile logo-->
                <div class="d-flex align-items-center flex-grow-1 flex-lg-grow-0">
                    <a href="index.html" class="d-lg-none">
                        <img alt="Logo" src="assets/media/my_media/logo.png" class="h-30px"/>
                    </a>
                </div>
                <!--end::Mobile logo-->
                <!--begin::Header wrapper-->
                <div class="d-flex align-items-stretch justify-content-between flex-lg-grow-1"
                     id="kt_app_header_wrapper">
                    <!--begin::Menu wrapper-->
                    <div class="app-header-menu app-header-mobile-drawer align-items-stretch" data-kt-drawer="true"
                         data-kt-drawer-name="app-header-menu" data-kt-drawer-activate="{default: true, lg: false}"
                         data-kt-drawer-overlay="true" data-kt-drawer-width="250px" data-kt-drawer-direction="end"
                         data-kt-drawer-toggle="#kt_app_header_menu_toggle" data-kt-swapper="true"
                         data-kt-swapper-mode="{default: 'append', lg: 'prepend'}"
                         data-kt-swapper-parent="{default: '#kt_app_body', lg: '#kt_app_header_wrapper'}">
                        <!--begin::Menu-->
                        <div class="menu menu-rounded menu-column menu-lg-row my-5 my-lg-0 align-items-stretch fw-semibold px-2 px-lg-0"
                             id="kt_app_header_menu" data-kt-menu="true">
                        </div>
                        <!--end::Menu-->
                    </div>
                    <!--end::Menu wrapper-->
                    <!--begin::Navbar-->
                    <div class="app-navbar flex-shrink-0">
                        <!--begin::User menu-->
                        <div class="app-navbar-item ms-1 ms-md-4" id="kt_header_user_menu_toggle">
                            <!--begin::Menu wrapper-->
                            <div class="cursor-pointer symbol symbol-35px"
                                 data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-attach="parent"
                                 data-kt-menu-placement="bottom-end">
                                <img src="<?php echo "../".$user["pic"] ?? "assets/media/avatars/blank.png" ?>" class="rounded-3" alt="user"/>
                            </div>
                            <!--begin::User account menu-->
                            <div  class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg menu-state-color fw-semibold py-4 fs-6 w-275px"
                                  data-kt-menu="true">
                                <!--begin::Menu item-->
                                <div class="menu-item px-3">
                                    <div class="menu-content d-flex align-items-center px-3">
                                        <!--begin::Avatar-->
                                        <div class="symbol symbol-50px me-5">
                                            <img alt="Logo" src="<?php echo "../".$user["pic"] ?? "assets/media/avatars/blank.png" ?>"/>
                                        </div>
                                        <!--end::Avatar-->
                                        <!--begin::Username-->
                                        <div class="d-flex flex-column">
                                            <div class="fw-bold d-flex align-items-center fs-6"><?php echo $user["name"] ?? "نام و نام خانوادگی" ?>
                                            </div>
                                        </div>
                                        <!--end::Username-->
                                    </div>
                                </div>
                                <!--end::Menu item-->
                                <!--begin::Menu separator-->
                                <div class="separator my-2"></div>
                                <!--end::Menu separator-->
                                <!--begin::Menu item-->
                                <div class="menu-item px-5 my-1">
                                    <a href="/admin/setting" class="menu-link px-5">تنظیمات اکانت</a>
                                </div>
                                <!--end::Menu item-->
                                <!--begin::Menu item-->
                                <div class="menu-item px-5" data-kt-menu-trigger="{default: 'click', lg: 'hover'}"
                                     data-kt-menu-placement="left-start" data-kt-menu-offset="-15px, 0">
                                    <a href="#" class="menu-link px-5">
												<span class="menu-title position-relative">مود سایت
												<span class="ms-5 position-absolute translate-middle-y top-50 end-0">
													<i class="ki-duotone ki-night-day theme-light-show fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
														<span class="path3"></span>
														<span class="path4"></span>
														<span class="path5"></span>
														<span class="path6"></span>
														<span class="path7"></span>
														<span class="path8"></span>
														<span class="path9"></span>
														<span class="path10"></span>
													</i>
													<i class="ki-duotone ki-moon theme-dark-show fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
													</i>
												</span></span>
                                    </a>
                                    <!--begin::Menu-->
                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-title-gray-700 menu-icon-gray-500 menu-active-bg menu-state-color fw-semibold py-4 fs-base w-150px"
                                         data-kt-menu="true" data-kt-element="theme-mode-menu">
                                        <!--begin::Menu item-->
                                        <div class="menu-item px-3 my-0">
                                            <a href="#" class="menu-link px-3 py-2" data-kt-element="mode"
                                               data-kt-value="light">
														<span class="menu-icon" data-kt-element="icon">
															<i class="ki-duotone ki-night-day fs-2">
																<span class="path1"></span>
																<span class="path2"></span>
																<span class="path3"></span>
																<span class="path4"></span>
																<span class="path5"></span>
																<span class="path6"></span>
																<span class="path7"></span>
																<span class="path8"></span>
																<span class="path9"></span>
																<span class="path10"></span>
															</i>
														</span>
                                                <span class="menu-title">روشن</span>
                                            </a>
                                        </div>
                                        <!--end::Menu item-->
                                        <!--begin::Menu item-->
                                        <div class="menu-item px-3 my-0">
                                            <a href="#" class="menu-link px-3 py-2" data-kt-element="mode"
                                               data-kt-value="dark">
														<span class="menu-icon" data-kt-element="icon">
															<i class="ki-duotone ki-moon fs-2">
																<span class="path1"></span>
																<span class="path2"></span>
															</i>
														</span>
                                                <span class="menu-title">تاریک</span>
                                            </a>
                                        </div>
                                        <!--end::Menu item-->
                                    </div>
                                    <!--end::Menu-->
                                </div>
                                <!--end::Menu item-->
                                <!--begin::Menu item-->
                                <div class="menu-item px-5">
                                    <a href="/" class="menu-link px-5">خروج</a>
                                </div>
                                <!--end::Menu item-->
                            </div>
                            <!--end::User account menu-->
                            <!--end::Menu wrapper-->
                        </div>
                        <!--end::User menu-->
                        <!--begin::Header menu toggle-->
                        <div class="app-navbar-item d-lg-none ms-2 me-n2" title="Show header menu">
                            <div class="btn btn-flex btn-icon btn-active-color-primary w-30px h-30px"
                                 id="kt_app_header_menu_toggle">
                                <i class="ki-duotone ki-element-4 fs-1">
                                    <span class="path1"></span>
                                    <span class="path2"></span>
                                </i>
                            </div>
                        </div>
                        <!--end::Header menu toggle-->
                        <!--begin::Aside toggle-->
                        <!--end::Header menu toggle-->
                    </div>
                    <!--end::Navbar-->
                </div>
                <!--end::Header wrapper-->
            </div>
            <!--end::Header container-->
        </div>
        <!--end::Header-->
        <!--begin::Wrapper-->
        <div class="app-wrapper flex-column flex-row-fluid" id="kt_app_wrapper">
            <!--begin::Sidebar-->
            <div id="kt_app_sidebar" class="app-sidebar flex-column" data-kt-drawer="true"
                 data-kt-drawer-name="app-sidebar" data-kt-drawer-activate="{default: true, lg: false}"
                 data-kt-drawer-overlay="true" data-kt-drawer-width="225px" data-kt-drawer-direction="start"
                 data-kt-drawer-toggle="#kt_app_sidebar_mobile_toggle">
                <!--begin::Logo-->
                <div class="app-sidebar-logo px-6" id="kt_app_sidebar_logo">
                    <!--begin::Logo image-->
                    <a href="/admin">
                        <img alt="Logo" src="assets/media/my_media/logo3.png"
                             class="h-55px app-sidebar-logo-default"/>
                        <img alt="Logo" src="assets/media/my_media/logo.png"
                             class="h-30px app-sidebar-logo-minimize"/>
                    </a>
                    <!--end::Logo image-->
                    <!--begin::Sidebar toggle-->
                    <!--begin::Minimized sidebar setup:
                                        if (isset($_COOKIE["sidebar_minimize_state"]) && $_COOKIE["sidebar_minimize_state"] === "on") {
                                        1. "src/js/layout/sidebar.js" adds "sidebar_minimize_state" cookie value to save the sidebar minimize state.
                                        2. Set data-kt-app-sidebar-minimize="on" attribute for body tag.
                                        3. Set data-kt-toggle-state="active" attribute to the toggle element with "kt_app_sidebar_toggle" id.
                                        4. Add "active" class to to sidebar toggle element with "kt_app_sidebar_toggle" id.
                                    }
                                -->
                    <div id="kt_app_sidebar_toggle"
                         class="app-sidebar-toggle btn btn-icon btn-shadow btn-sm btn-color-muted btn-active-color-primary h-30px w-30px position-absolute top-50 start-100 translate-middle rotate"
                         data-kt-toggle="true" data-kt-toggle-state="active" data-kt-toggle-target="body"
                         data-kt-toggle-name="app-sidebar-minimize">
                        <i class="ki-duotone ki-black-left-line fs-3 rotate-180">
                            <span class="path1"></span>
                            <span class="path2"></span>
                        </i>
                    </div>
                    <!--end::Sidebar toggle-->
                </div>
                <!--end::Logo-->
                <!--begin::sidebar menu-->
                <div class="app-sidebar-menu overflow-hidden flex-column-fluid">
                    <!--begin::Menu wrapper-->
                    <div id="kt_app_sidebar_menu_wrapper" class="app-sidebar-wrapper">
                        <!--begin::Scroll wrapper-->
                        <div id="kt_app_sidebar_menu_scroll" class="scroll-y my-5 mx-3" data-kt-scroll="true"
                             data-kt-scroll-activate="true" data-kt-scroll-height="auto"
                             data-kt-scroll-dependencies="#kt_app_sidebar_logo, #kt_app_sidebar_footer"
                             data-kt-scroll-wrappers="#kt_app_sidebar_menu" data-kt-scroll-offset="5px"
                             data-kt-scroll-save-state="true">
                            <!--begin::Menu-->
                            <div class="menu menu-column menu-rounded menu-sub-indention fw-semibold fs-6"
                                 id="#kt_app_sidebar_menu" data-kt-menu="true" data-kt-menu-expand="false">
                                <!--begin:Menu item-->
                                <div data-kt-menu-trigger="click" class=" menu-item menu-accordion">
                                    <!--begin:Menu link-->
                                    <a href="/adminshop/dashboard" class="menu-link">
												<span class="menu-icon">
													<i class="ki-duotone ki-element-11 fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
														<span class="path3"></span>
														<span class="path4"></span>
													</i>
												</span>
                                        <span class="menu-title fw-bold fs-4 ">فروشندگان</span>
                                    </a>
                                    <!--end:Menu link-->
                                </div>
                                <!--end:Menu item-->
                                <!--begin:Menu item-->
                                <div data-kt-menu-trigger="click" class=" menu-item menu-accordion">
                                    <!--begin:Menu link-->
                                    <a href="/adminshop/products" class="menu-link">
												<span class="menu-icon">
													<i class="ki-duotone ki-element-11 fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
														<span class="path3"></span>
														<span class="path4"></span>
													</i>
												</span>
                                        <span class="menu-title fw-bold fs-4 ">محصولات</span>
                                    </a>
                                    <!--end:Menu link-->
                                </div>
                                <!--end:Menu item-->
                                <!--begin:Menu item-->
                                <div data-kt-menu-trigger="click" class=" menu-item menu-accordion">
                                    <!--begin:Menu link-->
                                    <a href="/adminshop/my-products" class="menu-link">
												<span class="menu-icon">
													<i class="ki-duotone ki-element-11 fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
														<span class="path3"></span>
														<span class="path4"></span>
													</i>
												</span>
                                        <span class="menu-title fw-bold fs-4 ">محصولات من</span>
                                    </a>
                                    <!--end:Menu link-->
                                </div>
                                <!--end:Menu item-->
                                <!--begin:Menu item-->
                                <div data-kt-menu-trigger="click" class=" menu-item menu-accordion">
                                    <!--begin:Menu link-->
                                    <a href="/adminshop/order" class="menu-link">
												<span class="menu-icon">
													<i class="ki-duotone ki-element-11 fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
														<span class="path3"></span>
														<span class="path4"></span>
													</i>
												</span>
                                        <span class="menu-title fw-bold fs-4 ">سفارش ها</span>
                                    </a>
                                    <!--end:Menu link-->
                                </div>
                                <!--end:Menu item-->
                                <!--begin:Menu item-->
                                <div data-kt-menu-trigger="click" class=" menu-item menu-accordion">
                                    <!--begin:Menu link-->
                                    <a href="/adminshop/users" class="menu-link">
												<span class="menu-icon">
													<i class="ki-duotone ki-element-11 fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
														<span class="path3"></span>
														<span class="path4"></span>
													</i>
												</span>
                                        <span class="menu-title fw-bold fs-4 ">کاربران</span>
                                    </a>
                                    <!--end:Menu link-->
                                </div>
                                <!--end:Menu item-->
                            </div>
                            <!--end::Menu-->
                        </div>
                        <!--end::Scroll wrapper-->
                    </div>
                    <!--end::Menu wrapper-->
                </div>
                <!--end::sidebar menu-->
                <!--begin::Footer-->
                <!--end::Footer-->
            </div>
            <!--end::Sidebar-->
            <!--begin::Main-->
            <div class="app-main flex-column flex-row-fluid" id="kt_app_main">
                <!--begin::Content wrapper-->
                <div class="d-flex flex-column flex-column-fluid">
                    <!--begin::Toolbar-->
                    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
                        <!--begin::Toolbar container-->
                        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
                            <!--begin::Page title-->
                            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                                <!--begin::Title-->
                                <h1 class="page-heading d-flex text-gray-900 fw-bold fs-1hx flex-column justify-content-center my-0">
                                    لیست محصولات</h1>
                                <!--end::Title-->
                                <!--begin::Breadcrumb-->
                                <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-5 my-0 pt-1">
                                    <!--begin::Item-->
                                    <li class="breadcrumb-item text-muted">
                                        <a href="/admin"
                                           class="text-muted text-hover-primary">داشبورد</a>
                                    </li>
                                    <!--end::Item-->
                                    <!--begin::Item-->
                                    <li class="breadcrumb-item">
                                        <span class="bullet bg-gray-500 w-5px h-2px"></span>
                                    </li>
                                    <!--end::Item-->
                                    <!--begin::Item-->
                                    <li class="breadcrumb-item text-muted">محصولات</li>
                                    <!--end::Item-->
                                </ul>
                                <!--end::Breadcrumb-->
                            </div>
                            <!--end::Page title-->
                        </div>
                        <!--end::Toolbar container-->
                    </div>
                    <!--end::Toolbar-->
                    <!--begin::Content-->
                    <div id="kt_app_content" class="app-content flex-column-fluid">
                        <!--begin::Content container-->
                        <div id="kt_app_content_container" class="app-container container-fluid">
                            <!--begin::Row-->
                            <div class="row g-5 g-xl-8">
                                <!--begin::Search vertical-->
                                <div class="d-flex flex-column flex-lg-row">
                                    <!--begin::Layout-->
                                    <div class="flex-lg-row-fluid">
                                        <!--begin::Toolbar-->
                                        <div class="d-flex flex-wrap flex-stack pb-7">
                                            <!--begin::Title-->
                                            <div class="d-flex flex-wrap align-items-center my-1">
                                                <h3 class="fw-bold me-5 my-1"> <?php echo count($reports); ?> محصول یافت شد </h3>
                                            </div>
                                            <!--end::Title-->
                                            <!--begin::Controls-->
                                            <div class="d-flex flex-wrap my-1">
                                                <!--begin::Tab nav-->
                                                <!--end::Tab nav-->
                                                <!--begin::Actions-->
                                                <a href="/adminshop/add-product" target="_blank" class="btn btn-light-primary" >
                                                    ساخت محصول جدید
                                                </a>
                                                <!--end::Actions-->
                                            </div>
                                            <!--end::Controls-->
                                        </div>
                                        <!--end::Toolbar-->
                                        <!--begin::Tab Content-->
                                        <div class="tab-content">
                                            <!--begin::Tab pane-->
                                            <div id="kt_project_users_table_pane" class="tab-pane show active">
                                                <!--begin::Card-->
                                                <div class="card card-flush">
                                                    <!--begin::Card body-->
                                                    <div class="card-body pt-0">
                                                        <!--begin::Table container-->
                                                        <div class="table-responsive">
                                                            <!--begin::Table-->
                                                            <table id="kt_project_users_table" class="table table-row-bordered table-row-dashed gy-4 align-middle fw-bold">
                                                                <thead class="fs-7 text-gray-500 text-uppercase">
                                                                <tr>
                                                                    <th class="min-w-50x text-start ">شناسه</th>
                                                                    <th class="min-w-250px text-start ">اطلاعات محصول</th>
                                                                    <th class="min-w-100x text-start ">وضعیت</th>
                                                                    <th class="min-w-100px text-start ">برند</th>
                                                                    <th class="min-w-100px text-start ">رم</th>
                                                                    <th class="min-w-100px text-start ">حافظه</th>
                                                                    <th class="min-w-100px text-start ">رضایت</th>
                                                                    <th class="min-w-150px text-start">تاریخ ثبت</th>
                                                                    <th class="min-w-50px text-start">اقدامات</th>
                                                                </tr>
                                                                </thead>
                                                                <tbody class="fs-6" id="report-list">
                                                                <?php foreach ($reports as $report) : ?>
                                                                    <tr class="reports" >
                                                                        <td class="text-start text-hover-primary"><?php echo $report["id"] ?></td>
                                                                        <td class="text-start text-hover-primary" >
                                                                            <div class="d-flex align-items-center">
                                                                                <!--begin::Thumbnail-->
                                                                                <a  class="symbol symbol-50px">
                                                                                    <span class="symbol-label" style="background-image:url(../<?php echo $report["image_url"]  ?>);"></span>
                                                                                </a>
                                                                                <!--end::Thumbnail-->

                                                                                <div class="ms-5">
                                                                                    <!--begin::Title-->
                                                                                    <a  class="text-gray-800 text-hover-primary fs-5 fw-bold" data-kt-ecommerce-product-filter="product_name"><?php echo $report["name"] ?></a>
                                                                                    <!--end::Title-->
                                                                                </div>
                                                                            </div>
                                                                        </td>
                                                                        <td class="text-start text-hover-primary"><?php if($report["is_vendor"]==1) :?>
                                                                                <span class="is_user badge badge-light-success fw-bold px-4 py-3">دارای فروشنده</span>
                                                                            <?php else: ?>
                                                                                <span class="is_user badge badge-danger fw-bold px-4 py-3">غیر فعال</span>
                                                                            <?php endif; ?>
                                                                        </td>
                                                                        <td class="text-start text-hover-primary"><?php echo $report["brand_id"] ?></td>
                                                                        <td class="text-start text-hover-primary"><?php echo $report["ram"] ?></td>
                                                                        <td class="text-start text-hover-primary"><?php echo $report["storage"] ?></td>
                                                                        <td class="text-end pe-0" data-order="rating-<?php echo $report["rate"] ?>">
                                                                            <div class="rating justify-content-start">
                                                                                <div class="rating-label <?php if ((int)$report["rate"] >= 1){echo "checked";} ?>">
                                                                                    <i class="ki-duotone ki-star fs-6"></i>
                                                                                </div>
                                                                                <div class="rating-label <?php if ((int)$report["rate"] >= 2){echo "checked";} ?>">
                                                                                    <i class="ki-duotone ki-star fs-6"></i>
                                                                                </div>
                                                                                <div class="rating-label <?php if ((int)$report["rate"] >= 3){echo "checked";} ?>">
                                                                                    <i class="ki-duotone ki-star fs-6"></i>
                                                                                </div>
                                                                                <div class="rating-label <?php if ((int)$report["rate"] >= 4){echo "checked";} ?>">
                                                                                    <i class="ki-duotone ki-star fs-6"></i>
                                                                                </div>
                                                                                <div class="rating-label <?php if ((int)$report["rate"] >= 5){echo "checked";} ?>">
                                                                                    <i class="ki-duotone ki-star fs-6"></i>
                                                                                </div>
                                                                            </div>
                                                                        </td>
                                                                        <td class="text-start"><?php echo shamsi($report["created_at"]) ?></td>
                                                                        <td class="justify-content-center">
                                                                            <a href="#" class="btn btn-light btn-active-light-primary btn-flex btn-center btn-sm" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">اقدام
                                                                                <i class="ki-duotone ki-down fs-5 ms-1"></i></a>
                                                                            <!--begin::Menu-->
                                                                            <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-125px py-4" data-kt-menu="true">
                                                                                <!--begin::Menu item-->
                                                                                <div class="menu-item px-3">
                                                                                    <a onclick="view_user(<?php echo $report["id"] ?>)"  class="menu-link px-3">ویرایش</a>
                                                                                </div>
                                                                                <!--end::Menu item-->
                                                                                <!--begin::Menu item-->
                                                                                <div class="menu-item px-3">
                                                                                    <a  class="menu-link px-3">تغییر وضعیت</a>
                                                                                </div>
                                                                                <!--end::Menu item-->
                                                                                <!--begin::Menu item-->
                                                                                <div class="menu-item px-3">
                                                                                    <a  class="menu-link px-3">محصولات</a>
                                                                                </div>
                                                                                <!--end::Menu item-->
                                                                                <!--begin::Menu item-->
                                                                                <div class="menu-item px-3">
                                                                                    <a  class="menu-link px-3">سفارش ها</a>
                                                                                </div>
                                                                                <!--end::Menu item-->
                                                                            </div>
                                                                            <!--end::Menu-->
                                                                        </td>
                                                                    </tr>
                                                                <?php endforeach; ?>
                                                                </tbody>
                                                            </table>
                                                            <!--end::Table-->
                                                        </div>
                                                        <!--end::Table container-->
                                                    </div>
                                                    <!--end::Card body-->
                                                </div>
                                                <!--end::Card-->
                                            </div>
                                            <!--end::Tab pane-->
                                        </div>
                                        <!--end::Tab Content-->
                                    </div>
                                    <!--end::Layout-->
                                </div>
                                <!--begin::Search vertical-->
                            </div>
                            <!--end::Row-->
                        </div>
                        <!--end::Content container-->
                    </div>
                    <!--end::Content-->
                </div>
                <!--end::Content wrapper-->
            </div>
            <!--end:::Main-->
        </div>
        <!--end::Wrapper-->
    </div>
    <!--end::Page-->
</div>
<!--end::App-->

<button type="button" class="hidden fade" id="change_status" data-bs-toggle="modal" data-bs-target="#kt_modal_stacked_1">
    Launch demo modal
</button>

<div class="modal fade" tabindex="-1" id="kt_modal_stacked_1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">تغغیر وضعیت فروشنده</h3>

                <!--begin::Close-->
                <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                    <i class="ki-duotone ki-cross fs-1"><span class="path1"></span><span class="path2"></span></i>
                </div>
                <!--end::Close-->
            </div>

            <div class="modal-body">
                <input type="text" id="id_user" class="hidden fade" >
                <label class="required fs-6 fw-semibold mb-2">وضعیت فروشنده</label>
                <select id="status_user" class="form-select form-select-solid" data-control="select2" data-hide-search="true" data-placeholder="Select a Team Member" name="target_assign">

                </select>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">کنسل</button>
                <button type="button" onclick="statues()" class="btn btn-primary">ذخیره تغییرات</button>
            </div>
        </div>
    </div>
</div>
<!--begin::Modal - view user-->
<a id="view_user" class=" fade hidden" data-bs-toggle="modal" data-bs-target="#kt_modal_new_target">Add New Target</a>
<div class="modal fade" id="kt_modal_new_target" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-duotone ki-cross fs-1">
                        <span class="path1"></span>
                        <span class="path2"></span>
                    </i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <!--begin::Heading-->
                <div class="mb-13 text-center">
                    <!--begin::Title-->
                    <h1 class="mb-3">نمایش فروشنده</h1>
                    <!--end::Title-->
                    <!--begin::Description-->
                    <!--end::Description-->
                </div>
                <!--end::Heading-->

                <!--begin::Input group-->
                <div class="row g-9 mb-8">
                    <!--begin::Col-->
                    <div class="col-md-6 fv-row">
                        <label class="fs-6 fw-semibold mb-2">نام و نام خانوادگی</label>
                        <input type="text" class="form-control form-control-solid" readonly id="name"  name="serial1" />
                    </div>
                    <!--end::Col-->
                    <!--begin::Col-->
                    <div class="col-md-6 fv-row">
                        <label class="fs-6 fw-semibold mb-2">کد ملی</label>
                        <input type="text" class="form-control form-control-solid" readonly id="codemeli"  name="serial1" />
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->
                <!--begin::Input group-->
                <div class="row g-9 mb-8">
                    <!--begin::Col-->
                    <div class="col-md-6 fv-row">
                        <label class="fs-6 fw-semibold mb-2">ایمیل</label>
                        <input type="text" class="form-control form-control-solid" readonly  id="email"  name="serial1" />
                    </div>
                    <!--end::Col-->
                    <!--begin::Col-->
                    <div class="col-md-6 fv-row">
                        <label class="fs-6 fw-semibold mb-2">شماره موبایل</label>
                        <input type="text" class="form-control form-control-solid" readonly id="mobile"  name="serial1" />
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->
                <!--begin::Input group-->
                <div class="row g-9 mb-8">
                    <!--begin::Col-->
                    <div class="col-md-6 fv-row">
                        <!--begin::Label-->
                        <label class="form-label required">نمایندگی</label>
                        <!--end::Label-->
                        <!--begin::Input-->
                        <select id="id_agent" class="form-select form-select-lg form-select-solid" >
                            <?php foreach ($agents as $agent) : ?>
                                <option value="<?php echo $agent["group_id"] ?>"><?php echo $agent["agent"] ?></option>
                            <?php endforeach; ?>
                        </select>
                        <!--end::Input-->
                    </div>
                    <!--end::Col-->
                    <!--begin::Col-->
                    <div class="col-md-6 fv-row">
                        <!--begin::Label-->
                        <label class="form-label required">ادمین</label>
                        <!--end::Label-->
                        <!--begin::Input-->
                        <select id="is_admin" class="form-select form-select-lg form-select-solid" >
                            <option value="0" >فروشنده</option>
                            <option value="1" >ادمین</option>
                        </select>
                        <!--end::Input-->
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->
                <!--begin::Input group-->
                <div class="row g-9 mb-8">
                    <!--begin::Col-->
                    <div class="col-md-6 fv-row">
                        <!--begin::Label-->
                        <label class="form-label required">سرپرست</label>
                        <!--end::Label-->
                        <!--begin::Input-->
                        <select id="type_user" class="form-select form-select-lg form-select-solid" >
                            <option value="0" >فروشنده</option>
                            <option value="1" >سرپرست</option>
                        </select>
                        <!--end::Input-->
                    </div>
                    <!--end::Col-->
                    <!--begin::Col-->
                    <div class="col-md-6 fv-row">

                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->

                <!--begin::Actions-->
                <div class=" justify-content-start  ">
                    <button type="button" onclick="update_user()" class="btn btn-primary">ویرایش</button>
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">بیخیال</button>
                </div>
                <!--end::Actions-->
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
<!--end::Modal - view user-->
<!--begin::Modal - view user-->
<a id="create_user" class=" fade hidden" data-bs-toggle="modal" data-bs-target="#kt_modal_new_user">Add New Target</a>
<div class="modal fade" id="kt_modal_new_user" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-duotone ki-cross fs-1">
                        <span class="path1"></span>
                        <span class="path2"></span>
                    </i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <!--begin::Heading-->
                <div class="mb-13 text-center">
                    <!--begin::Title-->
                    <h1 class="mb-3">ساخت فروشنده جدید</h1>
                    <!--end::Title-->
                    <!--begin::Description-->
                    <!--end::Description-->
                </div>
                <!--end::Heading-->

                <!--begin::Input group-->
                <div class="row mb-5">
                    <!--begin::Col-->
                    <div class="col-md-6 fv-row">
                        <!--begin::Email-->
                        <input type="text" placeholder="نام و نام خانوادگی" id="fullName2" name="fullName" autocomplete="off" class="form-control bg-transparent" />
                        <!--end::Email-->
                    </div>
                    <!--end::Col-->
                    <!--begin::Col-->
                    <div class="col-md-6 fv-row">
                        <!--begin::Email-->
                        <input type="text" placeholder="نام فروشگاه" id="vendor2" autocomplete="off" class="form-control bg-transparent" />
                        <!--end::Email-->
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->
                <!--begin::Input group-->
                <div class="row mb-5">
                    <!--begin::Col-->
                    <div class="col-md-6 fv-row">
                        <!--begin::Email-->
                        <input type="text" placeholder="شماره موبایل" id="phone2" autocomplete="off" class="form-control bg-transparent" />
                        <!--end::Email-->
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->
                <!--begin::Input group-->
                <div class="fv-row mb-8" data-kt-password-meter="true">
                    <!--begin::Wrapper-->
                    <div class="mb-1">
                        <!--begin::Input wrapper-->
                        <div class="position-relative mb-3">
                            <input class="form-control bg-transparent" type="password" placeholder="رمز" id="password2" autocomplete="off" />
                            <span class="btn btn-sm btn-icon position-absolute translate-middle top-50 end-0 me-n2" data-kt-password-meter-control="visibility">
												<i class="ki-duotone ki-eye-slash fs-2"></i>
												<i class="ki-duotone ki-eye fs-2 d-none"></i>
											</span>
                        </div>
                        <!--end::Input wrapper-->
                        <!--begin::Meter-->
                        <div class="d-flex align-items-center mb-3" data-kt-password-meter-control="highlight">
                            <div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
                            <div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
                            <div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
                            <div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px"></div>
                        </div>
                        <!--end::Meter-->
                    </div>
                    <!--end::Wrapper-->
                    <!--begin::Hint-->
                    <div class="text-muted">حداقل از هشت کارکتر استفاده کنید شامل عدد ،سمبل و حروف باشد</div>
                    <!--end::Hint-->
                </div>
                <!--end::Input group=-->
                <!--begin::Actions-->
                <div class="text-center">
                    <button onclick="sign_up()" type="submit" id="kt_sign_up_submit" class="btn btn-primary">
                        <!--begin::Indicator label-->
                        <span class="indicator-label">ساخت فروشنده</span>
                        <!--end::Indicator label-->
                    </button>
                </div>
                <!--end::Actions-->
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
<!--end::Modal - view user-->
<!--begin::Javascript-->
<script>var hostUrl = "assets/";</script>
<!--begin::Global Javascript Bundle(mandatory for all pages)-->
<script src="assets/plugins/global/plugins.bundle.js"></script>
<script src="assets/js/scripts.bundle.js"></script>
<!--end::Global Javascript Bundle-->
<!--begin::Vendors Javascript(used for this page only)-->
<script src="assets/plugins/custom/datatables/datatables.bundle.js"></script>
<!--end::Vendors Javascript-->
<!--begin::Custom Javascript(used for this page only)-->
<script src="assets/js/custom/apps/projects/users/users.js"></script>
<script src="assets/js/widgets.bundle.js"></script>
<script src="assets/js/custom/widgets.js"></script>
<script src="assets/js/custom/apps/chat/chat.js"></script>
<script src="assets/js/custom/utilities/modals/upgrade-plan.js"></script>
<script src="assets/js/custom/utilities/modals/create-app.js"></script>
<script src="assets/js/custom/utilities/modals/users-search.js"></script>
<script src="assets/js/myjs/ApiClient.js"></script>
<!--end::Custom Javascript-->
<script>
    const api = new ApiClient();

    function change_status(i,a) {
        document.querySelector("#change_status").click() ;
        document.querySelector("#id_user").value = i ;
        if (a===0){
            document.querySelector("#status_user").innerHTML ='<option value="0">عدم تایید</option> <option value="1">تایید</option>';
        }else{
            document.querySelector("#status_user").innerHTML ='<option value="1">تایید</option> <option value="0">عدم تایید</option>';
        }
    }
    function statues() {
        let status = document.querySelector("#status_user").value ;
        let id = document.querySelector("#id_user").value ;
        data = {
            "id" : id ,
            "status" : status
        }
        api.post("/api/user/status" ,data).then(
            response =>{
                console.log(response);
                if(response.status == "success"){
                    Swal.fire({
                        text: "ویرایش وضعیت انجام شد",
                        icon: "success",
                        confirmButtonText: "ادامه"
                    }).then(
                        () => {
                            window.location.reload();
                        }
                    )
                }else{
                    Swal.fire({
                        text: "مشکلی در ارتباط با سرور وجود دارد لطفا بعدا تلاش کنید",
                        icon: "error",
                        confirmButtonText: "ادامه"
                    });
                }

            }
        ).catch(
            error =>{
                console.log(error);
                Swal.fire({
                    text: "مشکلی در ارتباط با سرور وجود دارد لطفا بعدا تلاش کنید",
                    icon: "error",
                    confirmButtonText: "ادامه"
                });
            }
        )
    }
    function view_user(id){
        api.post("/api/user/view",{'id' : id}).then(
            response => {
                console.log(response);
                data = response.data ;
                document.querySelector("#email").value = data["email"];
                document.querySelector("#name").value = data["name"];
                document.querySelector("#codemeli").value = data["codemelli"];
                document.querySelector("#mobile").value = data["mobile"];
                document.querySelector("#id_agent").value = data["group_id"];
                document.querySelector("#type_user").value = data["is_head"];
                document.querySelector("#is_admin").value = data["admin"];
                document.querySelector("#view_user").click();
            }
        ).catch(
            error => {
                console.log(error);
            }
        )

    }
    function sign_up(){
        let password = document.querySelector("#password2");
        let phone = document.querySelector("#phone2");
        let fullName = document.querySelector("#fullName2");
        let vendor = document.querySelector("#vendor2");
        let valid = true;
        function markInvalid(field) {
            field.style.backgroundColor = "#f8d7da"; // قرمز کم‌رنگ
            valid = false;
        }
        function checkEmptyField(field) {
            if (!field.value) {
                markInvalid(field);
            } else {
                field.style.backgroundColor = ""; // بازگرداندن به حالت عادی
            }
        }
        function validateIranianNationalCode(code) {
            // اضافه کردن صفر به کدهایی که کمتر از 10 رقم هستند
            code = code.padStart(10, '0');

            // بررسی طول کد ملی
            if (!/^\d{10}$/.test(code)) {
                return false;
            }

            // بررسی اینکه همه ارقام یکسان نباشند
            if (/^(\d)\1{9}$/.test(code)) {
                return false;
            }

            // محاسبه مجموع وزن‌دار
            let sum = 0;
            for (let i = 0; i < 9; i++) {
                sum += parseInt(code[i]) * (10 - i);
            }

            // محاسبه باقی‌مانده و بررسی رقم کنترلی
            const remainder = sum % 11;
            const controlDigit = parseInt(code[9]);
            if ((remainder < 2 && controlDigit == remainder) || (remainder >= 2 && controlDigit == 11 - remainder)) {
                return true;
            }

            return false;
        }
        checkEmptyField(password);
        checkEmptyField(phone);
        checkEmptyField(fullName);
        checkEmptyField(vendor);
        function checkNumeric(field) {
            if (isNaN(field.value)) {
                markInvalid(field);
            } else {
                field.style.backgroundColor = "";
            }
        }
        checkNumeric(phone);
        if (!valid) {
            Swal.fire({
                text: "لطفا فیلدها را تکمیل کنید و مطمئن شوید مقادیر عددی صحیح هستند.",
                icon: "error",
                confirmButtonText: "تایید"
            });
            return; // ارسال درخواست متوقف شود
        }
        data = {
            "name" : fullName.value ,
            "vendor_name" : vendor.value  ,
            "phone" : phone.value   ,
            "password" : password.value
        }
        api.post("/api/admin/create/vendor",data).then(
            response =>{
                console.log(response);
                if (response.status == "success"){
                    Swal.fire({
                        text: "اکانت ساخته شد",
                        icon: "success",
                        confirmButtonText: "تایید"
                    }).then(() => {
                        window.location.reload();
                    });
                }else{
                    Swal.fire({
                        text: response.message,
                        icon: "error",
                        confirmButtonText: "باشه!"
                    });
                }
            }
        ).catch(
            error=>{
                Swal.fire({
                    text: "مشکلی در ارتباط با سرور وجود دارد، لطفا دوباره تلاش کنید.",
                    icon: "error",
                    confirmButtonText: "باشه!"
                });
            }
        )

    }
    function update_user() {
        email = document.querySelector("#email").value ;
        name = document.querySelector("#name").value ;
        codemeli = document.querySelector("#codemeli").value ;
        mobile = document.querySelector("#mobile").value ;
        data = {
            email : document.querySelector("#email").value,
            name : document.querySelector("#name").value,
            codemeli: document.querySelector("#codemeli").value,
            mobile: document.querySelector("#mobile").value,
            admin : document.querySelector("#is_admin").value,
            group_id : document.querySelector("#id_agent").value,
            is_head : document.querySelector("#type_user").value,
        }
        api.post("/api/user3/update" ,data).then(
            response =>{
                console.log(response.message);
                if(response.status == "success"){
                    Swal.fire({
                        text: "ویرایش با موفقیت انجام شد",
                        icon: "success",
                        confirmButtonText: "ادامه"
                    }).then(
                        () => {
                            window.location.reload();
                        }
                    )
                }else{
                    Swal.fire({
                        text: response.message,
                        icon: "error",
                        confirmButtonText: "ادامه"
                    });
                }

            }
        ).catch(
            error =>{
                console.log(error);
                Swal.fire({
                    text: "مشکلی در ارتباط با سرور وجود دارد لطفا بعدا تلاش کنید",
                    icon: "error",
                    confirmButtonText: "ادامه"
                });
            }
        )
    }
</script>
<!--end::Javascript-->
</body>
<!--end::Body-->
</html>