class ApiClient {
    constructor(baseURL= null) {
        this.baseURL = baseURL ?? "http://localhost:9005"; // آدرس پایه API
    }

    // متدی برای ارسال درخواست‌های POST
    async post(endpoint, data = {}, headers = {}) {
        // بررسی اینکه آیا داده‌ها از نوع FormData هستند یا خیر
        let myHeaders = new Headers({
            ...headers, // هر هدر اضافی‌ای که خواستی اضافه کنی
        });

        let requestOptions = {
            method: "POST",
            headers: myHeaders,
            redirect: "follow",
        };

        // اگر داده‌ها از نوع FormData هستند
        if (data instanceof FormData) {
            // نیازی به تنظیم هدر Content-Type در این حالت نیست
            requestOptions.body = data;
        } else {
            // در غیر این صورت، از URLSearchParams استفاده کن
            const urlencoded = new URLSearchParams();
            for (let key in data) {
                urlencoded.append(key, data[key]);
            }
            myHeaders.set("Content-Type", "application/x-www-form-urlencoded");
            requestOptions.body = urlencoded;
        }

        return this.request(endpoint, requestOptions);
    }

    // متدی برای ارسال درخواست‌های GET
    async get(endpoint, params = {}, headers = {}) {
        const myHeaders = new Headers({
            ...headers, // هر هدر اضافی‌ای که خواستی اضافه کنی
        });

        const urlParams = new URLSearchParams(params).toString();
        const fullURL = `${this.baseURL}${endpoint}?${urlParams}`;

        const requestOptions = {
            method: "GET",
            headers: myHeaders,
            redirect: "follow",
        };

        return this.request(fullURL, requestOptions);
    }

    // متدی برای ارسال هر نوع درخواست
    async request(url, options) {
        try {
            const response = await fetch(url, options);
            const text = await response.text();

            try {
                // تلاش برای تبدیل متن به JSON
                const json = JSON.parse(text);
                return json;
            } catch (error) {
                // اگر پاسخ JSON نبود، متن خام را برمی‌گرداند
                return text;
            }
        } catch (error) {
            console.error('API request failed:', error);
            throw error;
        }
    }
}

// استفاده از کلاس برای درخواست‌های GET و POST
// const api = new ApiClient('http://localhost:9000/api/');
//
// // درخواست POST به آدرس '/login'
// api.post('login', {
//     password: 'your_password',
//     personal_number: 'your_personal_number'
// }).then(response => {
//     console.log('POST response:', response);
// }).catch(error => {
//     console.error(error);
// });
//
// // درخواست GET به آدرس '/users'
// api.get('users', {
//     limit: 10,
//     page: 1
// }).then(response => {
//     console.log('GET response:', response);
// }).catch(error => {
//     console.error(error);
// });
