<?php
// Set CORS headers
header("Access-Control-Allow-Origin: *"); // همه دامنه‌ها را مجاز می‌کند. می‌توانی آن را به یک دامنه خاص تغییر دهی.
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS"); // متدهای مجاز
header("Access-Control-Allow-Headers: Content-Type, Authorization"); // هدرهای مجاز
use App\Core\Routing\Route ;
$route = new Route();
// start site urls
$route::get("/",["Site","home"]);
$route::get("/shop",["Site","shop"]);
$route::get("/product",["Site","product"]);
$route::get("/about_us" , ["Site","about"]);
$route::get("/roles" , ["Site","roles"]);
$route::get("/carts" , ["Site","Carts"]);
$route::get("/login",["Site","login"]);
$route::get("/login",["Site","login"]);
// end site

$route::post("/api/create/address",        ["Apis", "createAddress"]);
$route::post("/api/create/brand",          ["Apis", "createBrand"]);
$route::post("/api/create/card",           ["Apis", "createCard"]);
$route::post("/api/create/card-item",      ["Apis", "createCardItem"]);
$route::post("/api/create/color",          ["Apis", "createColor"]);
$route::post("/api/create/mobile",         ["Apis", "createMobile"]);
$route::post("/api/create/mobile-image",   ["Apis", "createMobileImage"]);
$route::post("/api/create/order",          ["Apis", "createOrder"]);
$route::post("/api/create/order-item",     ["Apis", "createOrderItem"]);
$route::post("/api/create/vendor-mobile",  ["Apis", "createVendorMobile"]);
// Auth apis
$route::post("/api/login" ,["Auth" ,"Login"]);
$route::post("/api/signup" ,["Auth" ,"Signup"]);
$route::post("/api/logout" ,["Auth" ,"Logout"]);
$route::post("/api/check-code" ,["Auth" ,"CheckCode"]);
$route::post("/api/forget-number",["Auth" ,"forget_number"]);
$route::post("/api/forget_code",["Auth" ,"forget_code"]);
$route::post("/api/new_password",["Auth" ,"new_password"]);
$route::post("/api/add/card",["Buy","addCard"]);
// Auth apis

$route::get("/api/view/mobile/active",["Apis", "viewALLMobile"]);
$route::get("/test",["Site","test"]);

// admin route
$route::get("/adminshop",["admin","login"]);
$route::get("/adminshop/dashboard",["admin","dashboard"]);
$route::get("/adminshop/products",["admin","products"]);
$route::get("/adminshop/add-product",["admin","addProduct"]);
$route::post("/api/upload" , ["ApiAdmin","uploadFile"]);
$route::get("/adminshop/my-products",["Vendor","products"]);
$route::get("/adminshop/vendor/add-product" ,["Vendor","addProduct"]);
// admin route

//admin api
$route::post("/api/admin/login",["ApiAdmin","login"]);
$route::post("/api/create/product",["ApiAdmin","createProduct"]);
$route::post("/api/admin/create/vendor",["ApiAdmin","createVendor"]);
$route::get("/api/search/mobile" , ["ApiAdmin","searchMobile"]);
//admin api