<?php

namespace App\Services;

class excel
{
    /**
     * خروجی گرفتن CSV به مرورگر برای دانلود کاربر.
     *
     * @param array $data داده‌های ورودی
     * @param string $filename نام فایل برای دانلود
     */
    public function outputArrayAsCSV(array $data, string $filename = 'export.csv'): void
    {
        // تنظیم هدرها برای دانلود فایل CSV
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="' . $filename . '"');

        // باز کردن خروجی برای نوشتن به مرورگر
        $output = fopen('php://output', 'w');

        if ($output === false) {
            throw new \Exception('خطا در باز کردن خروجی برای نوشتن');
        }

        // نوشتن داده‌ها در خروجی
        foreach ($data as $row) {
            fputcsv($output, $row);
        }

        // بستن خروجی
        fclose($output);
        exit(); // برای جلوگیری از اضافه شدن محتوای اضافی به خروجی
    }

    /**
     * ذخیره کردن CSV در مسیر مشخص شده.
     *
     * @param array $data داده‌های ورودی
     * @param string $filename نام فایل برای ذخیره
     * @return string مسیر فایل ذخیره شده
     */
    public function saveArrayAsCSV(array $data, string $filename = 'assets/excel/export.csv'): string
    {
        // بررسی و ایجاد دایرکتوری در صورت نیاز
        $directory = dirname($filename);
        if (!is_dir($directory)) {
            mkdir($directory, 0777, true);
        }

        // باز کردن فایل برای نوشتن
        $file = fopen($filename, 'w');

        if ($file === false) {
            throw new \Exception('خطا در باز کردن فایل برای نوشتن');
        }

        // نوشتن داده‌ها در فایل CSV
        foreach ($data as $row) {
            fputcsv($file, $row);
        }

        // بستن فایل
        fclose($file);

        return realpath($filename); // مسیر کامل فایل ذخیره شده
    }

    /**
     * تولید محتوای CSV به عنوان یک رشته برای استفاده در برنامه‌ها.
     *
     * @param array $data داده‌های ورودی
     * @return string محتوای CSV
     */
    public function generateCSVString($data)
    {
        // شروع با BOM برای UTF-8
        $output = "\xEF\xBB\xBF";

        // اضافه کردن هدرها (در صورت نیاز)
        $headers = array_keys($data[0]);
        $output .= implode(',', array_map(function($header) {
                return mb_convert_encoding($header, 'UTF-8'); // کدگذاری هدرها به UTF-8
            }, $headers)) . "\n"; // اضافه کردن هدرها و خط جدید

        // اضافه کردن داده‌ها
        foreach ($data as $row) {
            $output .= implode(',', array_map(function($value) {
                    return mb_convert_encoding($value, 'UTF-8'); // کدگذاری مقادیر به UTF-8
                }, $row)) . "\n"; // جدا کردن مقادیر با کاما
        }

        return $output;
    }
}