<?php

namespace App\Services;

use App\Database\Database;

class History {

    private $db;
    private $user_id;

    public function __construct($user_id) {
        $this->db = new Database();
        $this->user_id = $user_id;
    }

    // متد مقایسه تغییرات و ساخت تاریخچه
    public function createHistory($oldData, $newData, $reception_id) {
        // مقایسه داده‌ها
        foreach ($newData as $key => $newValue) {
            if (isset($oldData[$key]) && trim($oldData[$key]) !== trim($newValue)) {
                // درج تاریخچه تغییرات برای هر فیلد جداگانه
                $this->db->insert("reception_edit_histories", [
                    "changer" => $this->user_id,
                    "reception_id" => $reception_id,
                    "field" => $key,  // نام فیلدی که تغییر کرده
                    "before_value" => $oldData[$key],  // مقدار قبلی
                    "after_value" => $newValue,  // مقدار جدید
                    "created_at" => this_time(),  // زمان ایجاد تاریخچه
                    "updated_at" => this_time()   // زمان آخرین به‌روزرسانی تاریخچه
                ]);
            }
        }
    }
}
