<?php
namespace App\Repositories;

class VendorRepository extends BaseRepository
{
    protected string $table = 'vendor';

    public function findByName(string $name): ?array
    {
        $rows = $this->db->select(
            "SELECT * FROM `{$this->table}` WHERE `name` = :name",
            ['name' => $name]
        );
        return $rows[0] ?? null;
    }
    public function findBYPhone(string $phone): ?array
    {
        $rows = $this->db->select(
            "SELECT * FROM `{$this->table}` WHERE `phone` = :phone",
            ['phone' => $phone]
        );
        return $rows[0] ?? null;
    }
}
