<?php
namespace App\Repositories;

class VendorMobileRepository extends BaseRepository
{
    protected string $table = 'vendor_mobiles';

    public function findByVendor(int $vendorId): array
    {
        return $this->db->select(
            "SELECT * FROM `{$this->table}` WHERE `vendor_id` = :vid ORDER BY `id` DESC",
            ['vid' => $vendorId]
        );
    }
    public function findByMobile(int $vendorId): array
    {
        return $this->db->select(
            "SELECT * FROM `{$this->table}` WHERE `mobile_id` = :vid ORDER BY `price` ASC",
            ['vid' => $vendorId]
        );
    }
}
