<?php

namespace App\Models;

use App\Database\Database;

class Lists
{
    public function UserReport($id, $limit = null, $offset = null)
    {
        $db = new Database();
        $sql = "SELECT `id`, `serial`,`user_id`, `serial_id`,`customer_id`, `activation_start_date`,
       `guarantee_status`, `problem`, `situation`, `accessories`, `dex`, `estimated_time`, `estimated_cost`
     , `product_status`, `paziresh_status`, `file1`, `file2`, `file3`, `file4`, `file5`, `file6`, `kaar`, `kaar_serial`,
       `kaar_at`, `sh_baar`, `sh_baar2`, `ersal_agent_b_daftar_at`, `driaft_daftar_az_agent_at`, `ersal_daftar_b_agent_at`,
       `driaft_agent_az_daftar_at`, `driaf_moshtari_at`, `created_at`, `updated_at` FROM `receptions` WHERE `user_id` = $id ORDER BY id DESC ";
        if (isset($limit) and isset($offset)) {
            $sql .= "  LIMIT $limit OFFSET $offset";
        }
        $reports = $db->select($sql);
        $data = [];
        foreach ($reports as $report) {
            $serial = $db->select("SELECT  `code_dastgah`, `title`, `coding_derakhtvare`, `model`, `att1_code`,
           `att1_val`, `att2_code`, `att2_val`, `att3_code`, `att3_val`, `att4_code`, `att4_val`, `serial`, `serial2`, `company`
           , `sh_sanad`, `code_guarantee`, `sharh_guarantee`, `code_agent_service`, `agent_service`, `start_guarantee`,
             `expite_guarantee`, `is_import`, `added_by_user`, `approved`, `did`, `created_at`,
             `updated_at` FROM `serials` WHERE `id`=" . $report["serial_id"])[0];
            $customer = $db->select("SELECT  `name`, `codemelli`, `passport`, `mobile`, `phone`, `ostan`, `shahr`,
            `address`, `codeposti`, `file`, `created_at`, `updated_at` FROM `customers` WHERE `id` =" . $report["customer_id"])[0];
            $user = $this->Users(["id"=>$report["user_id"]])[0];
            $data[] = [
                "id" => $report["id"],
                "user_name" => $user["name"],
                "user_agent" => $user["agent"],
                "serial1" => $serial["serial"],
                "serial2" => $serial["serial2"],
                "title" => $serial["title"],
                "model" => $serial["model"],
                "company" => $serial["company"],
                "activation_start_date" => $report["activation_start_date"],
                "agent_service" => $serial["agent_service"],
                "customer" => $customer["name"],
                "customer_number" => $customer["codemelli"],
                "customer_mobile" => $customer["mobile"],
                "guarantee_status" => $report["guarantee_status"],
                "problem" => $report["problem"],
                "product_status" => $report["product_status"],
                "report_status" => $report["paziresh_status"],
                "created_at" => $report["created_at"],
            ];
        }
        return $data;
    }
    public function GroupReport($id, $limit = null, $offset = null)
    {
        $db = new Database();
        $sql = "SELECT `id`, `serial`,`user_id`,`group_id`, `serial_id`,`customer_id`, `activation_start_date`,
       `guarantee_status`, `problem`, `situation`, `accessories`, `dex`, `estimated_time`, `estimated_cost`
     , `product_status`, `paziresh_status`, `file1`, `file2`, `file3`, `file4`, `file5`, `file6`, `kaar`, `kaar_serial`,
       `kaar_at`, `sh_baar`, `sh_baar2`, `ersal_agent_b_daftar_at`, `driaft_daftar_az_agent_at`, `ersal_daftar_b_agent_at`,
       `driaft_agent_az_daftar_at`, `driaf_moshtari_at`, `created_at`, `updated_at` FROM `receptions` WHERE `group_id` = $id ORDER BY id DESC ";
        if (isset($limit) and isset($offset)) {
            $sql .= "  LIMIT $limit OFFSET $offset";
        }
        $reports = $db->select($sql);
        $data = [];
        foreach ($reports as $report) {
            $serial = $db->select("SELECT  `code_dastgah`, `title`, `coding_derakhtvare`, `model`, `att1_code`,
           `att1_val`, `att2_code`, `att2_val`, `att3_code`, `att3_val`, `att4_code`, `att4_val`, `serial`, `serial2`, `company`
           , `sh_sanad`, `code_guarantee`, `sharh_guarantee`, `code_agent_service`, `agent_service`, `start_guarantee`,
             `expite_guarantee`, `is_import`, `added_by_user`, `approved`, `did`, `created_at`,
             `updated_at` FROM `serials` WHERE `id`=" . $report["serial_id"])[0];
            $customer = $db->select("SELECT  `name`, `codemelli`, `passport`, `mobile`, `phone`, `ostan`, `shahr`,
            `address`, `codeposti`, `file`, `created_at`, `updated_at` FROM `customers` WHERE `id` =" . $report["customer_id"])[0];
            $user = $this->Users(["id"=>$report["user_id"]])[0];
            $data[] = [
                "id" => $report["id"],
                "user_name" => $user["name"],
                "user_agent" => $user["agent"],
                "serial1" => $serial["serial"],
                "serial2" => $serial["serial2"],
                "title" => $serial["title"],
                "model" => $serial["model"],
                "company" => $serial["company"],
                "activation_start_date" => $report["activation_start_date"],
                "agent_service" => $serial["agent_service"],
                "customer" => $customer["name"],
                "customer_number" => $customer["codemelli"],
                "customer_mobile" => $customer["mobile"],
                "guarantee_status" => $report["guarantee_status"],
                "problem" => $report["problem"],
                "product_status" => $report["product_status"],
                "report_status" => $report["paziresh_status"],
                "created_at" => $report["created_at"],
            ];
        }
        return $data;
    }
    public function serialReport($id, $limit = null, $offset = null)
    {
        $db = new Database();
        $sql = "SELECT `id`, `serial`, `serial_id`,`customer_id`, `activation_start_date`,
       `guarantee_status`, `problem`, `situation`, `accessories`, `dex`, `estimated_time`, `estimated_cost`
     , `product_status`, `paziresh_status`, `file1`, `file2`, `file3`, `file4`, `file5`, `file6`, `kaar`, `kaar_serial`,
       `kaar_at`, `sh_baar`, `sh_baar2`, `ersal_agent_b_daftar_at`, `driaft_daftar_az_agent_at`, `ersal_daftar_b_agent_at`,
       `driaft_agent_az_daftar_at`, `driaf_moshtari_at`, `created_at`, `updated_at` FROM `receptions` WHERE `serial_id` = $id ORDER BY id DESC ";
        if (isset($limit) and isset($offset)) {
            $sql .= "  LIMIT $limit OFFSET $offset";
        }
        $reports = $db->select($sql);
        $data = [];
        foreach ($reports as $report) {
            $serial = $db->select("SELECT  `code_dastgah`, `title`, `coding_derakhtvare`, `model`, `att1_code`,
           `att1_val`, `att2_code`, `att2_val`, `att3_code`, `att3_val`, `att4_code`, `att4_val`, `serial`, `serial2`, `company`
           , `sh_sanad`, `code_guarantee`, `sharh_guarantee`, `code_agent_service`, `agent_service`, `start_guarantee`,
             `expite_guarantee`, `is_import`, `added_by_user`, `approved`, `did`, `created_at`,
             `updated_at` FROM `serials` WHERE `id`=" . $report["serial_id"])[0];
            $customer = $db->select("SELECT  `name`, `codemelli`, `passport`, `mobile`, `phone`, `ostan`, `shahr`,
            `address`, `codeposti`, `file`, `created_at`, `updated_at` FROM `customers` WHERE `id` =" . $report["customer_id"])[0];
            $data[] = [
                "id" => $report["id"],
                "serial1" => $serial["serial"],
                "serial2" => $serial["serial2"],
                "title" => $serial["title"],
                "model" => $serial["model"],
                "company" => $serial["company"],
                "activation_start_date" => $report["activation_start_date"],
                "agent_service" => $serial["agent_service"],
                "customer" => $customer["name"],
                "customer_number" => $customer["codemelli"],
                "customer_mobile" => $customer["mobile"],
                "shahr" => $customer["shahr"],
                "ostan" => $customer["ostan"],
                "guarantee_status" => $report["guarantee_status"],
                "problem" => $report["problem"],
                "product_status" => $report["product_status"],
                "report_status" => $report["paziresh_status"],
                "created_at" => $report["created_at"],
            ];
        }
        return $data;
    }

    public function singleReport($id, $limit = null, $offset = null)
    {
        $db = new Database();
        $sql = "SELECT `id`,`user_id`, `serial`, `serial_id`,`customer_id`, `activation_start_date`,
       `guarantee_status`, `problem`, `situation`, `accessories`, `dex`, `estimated_time`, `estimated_cost`
     , `product_status`, `paziresh_status`, `file1`, `file2`, `file3`, `file4`, `file5`, `file6`, `kaar`, `kaar_serial`,
       `kaar_at`, `sh_baar`, `sh_baar2`, `ersal_agent_b_daftar_at`, `driaft_daftar_az_agent_at`, `ersal_daftar_b_agent_at`,
       `driaft_agent_az_daftar_at`, `driaf_moshtari_at`, `created_at`, `updated_at` FROM `receptions` WHERE `id` = $id ORDER BY id DESC ";
        if (isset($limit) and isset($offset)) {
            $sql .= "  LIMIT $limit OFFSET $offset";
        }
        $reports = $db->select($sql);
        $data = [];
        foreach ($reports as $report) {
            $serial = $db->select("SELECT  `code_dastgah`, `title`, `coding_derakhtvare`, `model`, `att1_code`,
           `att1_val`, `att2_code`, `att2_val`, `att3_code`, `att3_val`, `att4_code`, `att4_val`, `serial`, `serial2`, `company`
           , `sh_sanad`, `code_guarantee`, `sharh_guarantee`, `code_agent_service`, `agent_service`, `start_guarantee`,
             `expite_guarantee`, `is_import`, `added_by_user`, `approved`, `did`, `created_at`,
             `updated_at` FROM `serials` WHERE `id`=" . $report["serial_id"])[0];
            $customer = $db->select("SELECT  `name`, `codemelli`, `passport`, `mobile`, `phone`, `ostan`, `shahr`,
            `address`, `codeposti`, `file`, `created_at`, `updated_at` FROM `customers` WHERE `id` =" . $report["customer_id"])[0];
            $data[] = array_merge($serial,$customer,$report);
        }
        return $data[0];
    }

    public function Reports($limit = null, $offset = null)
    {
        $db = new Database();
        $sql = "SELECT `id`, `serial`,`user_id`,`group_id`, `serial_id`,`customer_id`, `activation_start_date`,
       `guarantee_status`, `problem`, `situation`, `accessories`, `dex`, `estimated_time`, `estimated_cost`
     , `product_status`, `paziresh_status`, `file1`, `file2`, `file3`, `file4`, `file5`, `file6`, `kaar`, `kaar_serial`,
       `kaar_at`, `sh_baar`, `sh_baar2`, `ersal_agent_b_daftar_at`, `driaft_daftar_az_agent_at`, `ersal_daftar_b_agent_at`,
       `driaft_agent_az_daftar_at`, `driaf_moshtari_at`, `created_at`, `updated_at` FROM `receptions` WHERE 1 ORDER BY id DESC ";
        if (isset($limit) and isset($offset)) {
            $sql .= "  LIMIT $limit OFFSET $offset";
        }
        $reports = $db->select($sql);
        $data = [];
        foreach ($reports as $report) {
            $serial = $db->select("SELECT  `code_dastgah`, `title`, `coding_derakhtvare`, `model`, `att1_code`,
           `att1_val`, `att2_code`, `att2_val`, `att3_code`, `att3_val`, `att4_code`, `att4_val`, `serial`, `serial2`, `company`
           , `sh_sanad`, `code_guarantee`, `sharh_guarantee`, `code_agent_service`, `agent_service`, `start_guarantee`,
             `expite_guarantee`, `is_import`, `added_by_user`, `approved`, `did`, `created_at`,
             `updated_at` FROM `serials` WHERE `id`=" . $report["serial_id"])[0];
            $customer = $db->select("SELECT  `name`, `codemelli`, `passport`, `mobile`, `phone`, `ostan`, `shahr`,
            `address`, `codeposti`, `file`, `created_at`, `updated_at` FROM `customers` WHERE `id` =" . $report["customer_id"])[0];
            $user = $this->Users(["id"=>$report["user_id"]])[0];
            $data[] = [
                "id" => $report["id"],
                "user_name" => $user["name"],
                "user_agent" => $user["agent"],
                "serial1" => $serial["serial"],
                "serial2" => $serial["serial2"],
                "title" => $serial["title"],
                "model" => $serial["model"],
                "company" => $serial["company"],
                "activation_start_date" => $report["activation_start_date"],
                "agent_service" => $serial["agent_service"],
                "customer" => $customer["name"],
                "customer_number" => $customer["codemelli"],
                "customer_mobile" => $customer["mobile"],
                "guarantee_status" => $report["guarantee_status"],
                "problem" => $report["problem"],
                "product_status" => $report["product_status"],
                "report_status" => $report["paziresh_status"],
                "created_at" => $report["created_at"],
            ];
        }
        return $data;
    }

    public function Customers($querys = null, $limit = null, $offset = null)
    {
        $db = new Database();
        $sql = "SELECT `id`, `name`, `codemelli`, `passport`, `mobile`, `phone`, `ostan`, `shahr`, `address`,
       `codeposti`, `file`, `created_at`, `updated_at` FROM `customers` WHERE 1";  // شرط `WHERE 1` برای تضمین صحت کوئری

        // بررسی ورودی‌ها و افزودن شروط مناسب
        if (isset($querys) && is_array($querys)) {
            foreach ($querys as $key => $value) {
                if (is_numeric($value)) {
                    $sql .= " AND $key = $value";  // اگر مقدار عددی است، بدون کوتیشن
                } else {
                    $sql .= " AND $key = '$value'";  // اگر مقدار رشته‌ای است، در داخل کوتیشن قرار می‌دهیم
                }
            }
        }

        // اضافه کردن دستور `ORDER BY`
        $sql .= " ORDER BY id DESC";

        // افزودن LIMIT و OFFSET در صورت وجود
        if (isset($limit) && isset($offset)) {
            $sql .= " LIMIT $limit OFFSET $offset";
        }

        // اجرای کوئری و بازگرداندن نتایج
        $customer = $db->select($sql);
        return $customer;
    }
    public function CustomerOr($querys = null, $limit = null, $offset = null)
    {
        $db = new Database();
        $sql = "SELECT `id`, `name`, `codemelli`, `passport`, `mobile`, `phone`, `ostan`, `shahr`, `address`,
       `codeposti`, `file`, `created_at`, `updated_at` FROM `customers` WHERE";
        if (isset($querys)) {
            $count = count($querys);
            foreach ($querys as $key => $value) {
                $count = $count - 1;
                if ($count == 0) {
                    $sql .= " $key = $value ";
                } else {
                    $sql .= " `$key` = `$value` OR ";
                }
            }
        } else {
            $sql .= " 1 ORDER BY id DESC ";
        }
        if (isset($limit) and isset($offset)) {
            $sql .= "  LIMIT $limit OFFSET $offset";
        }
        $customer = $db->select($sql);
        return $customer;
    }

    public function SerialsSearch($serial)
    {
        $sql = "SELECT `id` , `code_dastgah`, `title`, `coding_derakhtvare`, `model`, `att1_code`,
           `att1_val`, `att2_code`, `att2_val`, `att3_code`, `att3_val`, `att4_code`, `att4_val`, `serial`, `serial2`, `company`
           , `sh_sanad`, `code_guarantee`, `sharh_guarantee`, `code_agent_service`, `agent_service`, `start_guarantee`,
             `expite_guarantee`, `is_import`, `added_by_user`, `approved`, `did`, `created_at`,
             `updated_at` FROM `serials` WHERE serial = $serial OR serial2= $serial ";
        $db = new Database();
        $response = $db->select($sql);
        return $response;
    }

    public function Serials($querys = null, $limit = null, $offset = null , $search = null)
    {
        $db = new Database();
        $sql = "SELECT `id` , `code_dastgah`, `title`, `coding_derakhtvare`, `model`, `att1_code`,
           `att1_val`, `att2_code`, `att2_val`, `att3_code`, `att3_val`, `att4_code`, `att4_val`, `serial`, `serial2`, `company`
           , `sh_sanad`, `code_guarantee`, `sharh_guarantee`, `code_agent_service`, `agent_service`, `start_guarantee`,
             `expite_guarantee`, `is_import`, `added_by_user`, `approved`, `did`, `created_at`,
             `updated_at` FROM `serials` WHERE";
        if (isset($querys)) {
            $count = count($querys);
            foreach ($querys as $key => $value) {
                $count = $count - 1;
                if ($count == 0) {
                    $sql .= " $key = $value ";
                } else {
                    $sql .= " $key = $value AND ";
                }
            }
            $sql .= " ORDER BY id DESC ";
        } else {
            if (isset($search)){
                $sql .= " `serial` LIKE '%".$search."%' OR `serial2` LIKE '%".$search."%' ORDER BY id DESC  ";
            }else{
                $sql .= " 1 ORDER BY id DESC ";
            }
        }
        if (isset($limit) and isset($offset)) {
            $sql .= "  LIMIT $limit OFFSET $offset";
        }
        return $db->select($sql);

    }

    public function Users($querys = null, $limit = null, $offset = null)
    {
        $db = new Database();
        $sql = "SELECT `id`, `admin`, `is_head`, `group_id`, `email`, `password`, `name`, `codemelli`, `mobile`, `ostan`, `shahr`,
       `address`, `phone`, `hours`, `agent`, `codeposti`, `avatar`, `otp`, `otp_expire_at`, `email_verification_code`,
       `email_verified_at`, `banned`, `approved`, `permission`, `remember_token`, `created_at`, `updated_at`,
       `deleted_at` FROM `users` WHERE";
        if (isset($querys)) {
            $count = count($querys);
            foreach ($querys as $key => $value) {
                $count = $count - 1;
                if ($count == 0) {
                    $sql .= " $key = $value ";
                } else {
                    $sql .= " $key = $value AND ";
                }
            }
            $sql .= " ORDER BY id DESC ";
        } else {
            $sql .= " 1 ORDER BY id DESC ";
        }
        if (isset($limit) and isset($offset)) {
            $sql .= "  LIMIT $limit OFFSET $offset";
        }
        return $db->select($sql);
    }

    public function reseption($querys = null, $limit = null, $offset = null)
    {
        $db = new Database();
        $sql = "SELECT `id`, `serial`, `serial_id`, `user_id`, `customer_id`, `activation_start_date`,
       `guarantee_status`, `problem`, `situation`, `accessories`, `dex`, `estimated_time`, `estimated_cost`,
       `product_status`, `paziresh_status`, `file1`, `file2`, `file3`, `file4`, `file5`, `file6`, `kaar`,
       `kaar_serial`, `kaar_at`, `sh_baar`, `sh_baar2`, `ersal_agent_b_daftar_at`, `driaft_daftar_az_agent_at`,
       `ersal_daftar_b_agent_at`, `driaft_agent_az_daftar_at`, `driaf_moshtari_at`, `created_at`, `updated_at`
        FROM `receptions` WHERE ";
        if (isset($querys)) {
            $count = count($querys);
            foreach ($querys as $key => $value) {
                $count = $count - 1;
                if ($count == 0) {
                    $sql .= " $key = $value ";
                } else {
                    $sql .= " $key = $value AND ";
                }
            }
            $sql .= " ORDER BY id DESC ";
        } else {
            $sql .= " 1 ORDER BY id DESC ";
        }
        if (isset($limit) and isset($offset)) {
            $sql .= "  LIMIT $limit OFFSET $offset";
        }
        return $db->select($sql);
    }

    public function accessory()
    {
        $sql = "SELECT `id`, `accessory`, `created_at`, `updated_at` FROM `product_accessories` WHERE 1 ORDER BY id DESC";
        $db = new Database();
        $acc = $db->select($sql);
        return $acc ;
    }
    public function statuses()
    {
        $sql = "SELECT `status` FROM `product_statuses` WHERE 1";
        $db = new Database();
        $statuses = $db->select($sql);
        return $statuses;
    }
    public function productStatus()
    {
        $sql = "SELECT `id`, `status`, `created_at`, `updated_at` FROM `product_statuses` WHERE 1 ORDER BY id DESC";
        $db = new Database();
        $statuses = $db->select($sql);
        return $statuses;
    }
    public function garantyStatus()
    {
        $sql = "SELECT `id`, `status`, `created_at`, `updated_at` FROM `guarantee_statuses` WHERE 1 ORDER BY id DESC";
        $db = new Database();
        $statuses = $db->select($sql);
        return $statuses;
    }
    public function kars()
    {
        $sql = "SELECT `id`, `kaar`, `created_at`, `updated_at` FROM `kaars` WHERE 1 ORDER BY id DESC";
        $db = new Database();
        $statuses = $db->select($sql);
        return $statuses;
    }


    public function print()
    {
        $sql = "SELECT `name`, `value` FROM `settings` WHERE 1";
        $db = new Database();
        $print = $db->select($sql);
        $data = [];
        foreach ($print as $value) {
            $data[$value['name']] = $value['value'];
        }
        return $data;
    }
    public function ticket($querys = null, $limit = null, $offset = null)
    {
        $db = new Database();
        $sql = "SELECT `id`, `user_id`, `title`, `vb_user`, `vb_admin`, `status`, `created_at`, `updated_at` 
        FROM `tickets` WHERE ";
        if (isset($querys)) {
            $count = count($querys);
            foreach ($querys as $key => $value) {
                $count = $count - 1;
                if ($count == 0) {
                    $sql .= " $key = $value ";
                } else {
                    $sql .= " $key = $value AND ";
                }
            }
            $sql .= " ORDER BY id DESC ";
        } else {
            $sql .= " 1 ORDER BY id DESC ";
        }
        if (isset($limit) and isset($offset)) {
            $sql .= "  LIMIT $limit OFFSET $offset";
        }
        return $db->select($sql);
    }
    public function massage($querys = null, $limit = null, $offset = null)
    {
        $db = new Database();
        $sql = "SELECT `id`, `ticket_id`, `sender`, `dex`, `attach`, `created_at`, `updated_at` FROM `ticket_messages` WHERE ";
        if (isset($querys)) {
            $count = count($querys);
            foreach ($querys as $key => $value) {
                $count = $count - 1;
                if ($count == 0) {
                    $sql .= " $key = $value ";
                } else {
                    $sql .= " $key = $value AND ";
                }
            }
            $sql .= " ORDER BY id ASC ";
        } else {
            $sql .= " 1 ORDER BY id ASC ";
        }
        if (isset($limit) and isset($offset)) {
            $sql .= "  LIMIT $limit OFFSET $offset";
        }
        return $db->select($sql);
    }
    public function historis($querys = null, $limit = null, $offset = null)
    {
        $db = new Database();
        $sql = "SELECT `id`, `changer`, `reception_id`, `field`, `before_value`, `after_value`, `created_at`, `updated_at`
                FROM `reception_edit_histories` WHERE ";
        if (isset($querys)) {
            $count = count($querys);
            foreach ($querys as $key => $value) {
                $count = $count - 1;
                if ($count == 0) {
                    $sql .= " $key = $value ";
                } else {
                    $sql .= " $key = $value AND ";
                }
            }
            $sql .= " ORDER BY id DESC ";
        } else {
            $sql .= " 1 ORDER BY id DESC ";
        }
        if (isset($limit) and isset($offset)) {
            $sql .= "  LIMIT $limit OFFSET $offset";
        }
        return $db->select($sql);
    }

    public function att1()
    {
        $sql = "SELECT `id`, `title`, `code`, `created_at`, `updated_at` FROM `code_att1` WHERE 1 ORDER BY id DESC";
        $db = new Database();
        $acc = $db->select($sql);
        return $acc ;
    }
    public function att2()
    {
        $sql = "SELECT `id`, `title`, `code`, `created_at`, `updated_at` FROM `code_att2` WHERE 1 ORDER BY id DESC";
        $db = new Database();
        $acc = $db->select($sql);
        return $acc ;
    }
    public function att3()
    {
        $sql = "SELECT `id`, `title`, `code`, `created_at`, `updated_at` FROM `code_att3` WHERE 1 ORDER BY id DESC";
        $db = new Database();
        $acc = $db->select($sql);
        return $acc ;
    }
    public function att4()
    {
        $sql = "SELECT `id`, `title`, `code`, `created_at`, `updated_at` FROM `code_att4` WHERE 1 ORDER BY id DESC";
        $db = new Database();
        $acc = $db->select($sql);
        return $acc ;
    }
    public function code_product()
    {
        $sql = "SELECT `id`, `title`, `code`, `created_at`, `updated_at` FROM `code_product` WHERE 1 ORDER BY id DESC";
        $db = new Database();
        $acc = $db->select($sql);
        return $acc ;
    }


}