<?php 
namespace App\Core\Http;

class Request
{
    public static function uri()
    {
        return parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    }

    public static function method()
    {
        return $_SERVER['REQUEST_METHOD'];
    }

    public static function params()
    {
        return $_REQUEST;
    }

    public static function input($key)
    {
         if (isset($_REQUEST[$key]) and !empty($_REQUEST[$key])) {

             return trim($_REQUEST[$key])  ?? null;
         }else{
             return null;
         }
    }

    public static function isPost()
    {
        return self::method() === 'POST';
    }

    public static function isGet()
    {
        return self::method() === 'GET';
    }
    public static function isAjax()
    {
        return $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest';
    }
    public static function isSecure()
    {
        return $_SERVER['HTTPS'] === 'on';
    }
    public static function ip()
    {
        return $_SERVER['REMOTE_ADDR'];
    }
    public static function host()
    {
        return $_SERVER['HTTP_HOST'];
    }
    public static function isset($key)
    {
        return isset($_REQUEST[$key]);
    }
    public static function redirect($url)
    {
        header('Location: ' . $url);
        exit;
    }
    public static function file($key)
    {
    if ($key) {
        return $_FILES[$key] ?? null;
    }
    return $_FILES;
    }
    
}