<?php

namespace App\Controllers;

use App\Repositories\BrandRepository;
use App\Repositories\ColorRepository;
use App\Repositories\MobileRepository;
use App\Repositories\VendorMobileRepository;

class Vendor
{
    public function products(){
        is_logged_in();
        $mobile = new MobileRepository();
        $brand = new BrandRepository();
        $vmobile = new VendorMobileRepository();
        $color = new ColorRepository();
        $all = $vmobile->findByVendor($_SESSION["user"]["id"]);
        $data = [];
        foreach ($all as $item){
            $mdata = $mobile->findById($item["mobile_id"]);
            $data2 = [
                "brand" => $brand->findById($mdata["brand_id"])["name"],
                "color" => $color->findById($item["color_id"])["name"],
                "name" => $mdata["name"],
                "ram"  => $mdata["ram"],
                "storage" => $mdata["storage"],
                "rate" => $mdata["rate"],
                "image_url" => $mdata["image_url"],
            ];
            $data[] = array_merge($item,$data2);
        }
        $res = [
            "user" => $_SESSION["user"],
            "reports" => $data
        ];
        view("admin/vendor/products", $res);
    }
    public function addProduct(){
        is_logged_in();
        $mobile = new MobileRepository();
        $brand = new BrandRepository();
        $color = new ColorRepository();
        $data = [
          "brands" => $brand->all(),
          "rams" => $mobile->getRams(),
          "storages" => $mobile->getStorage(),
          "user" => $_SESSION["user"],
          "colors" => $color->all(),
        ];
//        var_dump($data);
        view("admin/vendor/add-product", $data);
    }


}