<?php

namespace App\Controllers;

use App\Core\Http\Request;
use App\Core\Response\Response;
use App\Repositories\CardItemRepository;
use App\Repositories\CardRepository;
use App\Repositories\VendorMobileRepository;

class Buy
{
    public function addCard()
    {
        session_start();
        $request     = new Request();
        $response    = new Response();
        $repcard     = new CardRepository();
        $repcardItem = new CardItemRepository();
        $repvmobile  = new VendorMobileRepository();

        try {
            // 1. ورودی‌ها را بگیرید و چک کنید
            $vmobile_id = $request::input("vendor_mobile_id");
            $color_id   = $request::input("color_id");
            $user_id    = $_SESSION["user"]["id"] ?? null;

            if (empty($vmobile_id) || empty($color_id) || empty($user_id)) {
                $response->notAcceptable("لطفا پارامترهای ورودی را تنظیم کنید")
                    ->respond();
                return;
            }

            // 2. موجودی کالا را بررسی کنید
            $mobile = $repvmobile->findById($vmobile_id);
            $count  = isset($mobile["count"]) ? (int)$mobile["count"] : 0;
            if (empty($mobile) || $count < 1) {
                $response->notFound("این موبایل در انبار موجود نمی‌باشد")
                    ->respond();
                return;
            }

            // 3. قیمت را محاسبه کنید (در صورت تخفیف)
            $isOff      = isset($mobile["is_off"]) ? (int)$mobile["is_off"] : 0;
            $offPercent = isset($mobile["off_persent"]) ? (float)$mobile["off_persent"] : 0;
            $basePrice  = isset($mobile["price"]) ? (float)$mobile["price"] : 0;
            $price = $isOff === 1
                ? $basePrice - ($basePrice * $offPercent / 100)
                : $basePrice;

            // 4. سبد فعال کاربر را پیدا کنید
            $cards = $repcard->findByUserActive($user_id);
            $card  = (!empty($cards) && isset($cards[0]) && is_array($cards[0]))
                ? $cards[0]
                : null;

            if ($card !== null && isset($card["id"], $card["total_price"])) {
                // 5. اگر سبد موجود بود، آیتم داخل آن را بررسی/بروزرسانی کنید
                $cardId       = (int)$card["id"];
                $currentTotal = (int)$card["total_price"];

                $lastItems = $repcardItem->findByMobile($cardId, $vmobile_id);
                $lastItem  = (!empty($lastItems) && isset($lastItems[0]) && is_array($lastItems[0]))
                    ? $lastItems[0]
                    : null;

                if ($lastItem !== null && isset($lastItem["id"], $lastItem["count"], $lastItem["total_price"])) {
                    // بروزرسانی تعداد و قیمت آیتم موجود
                    $newCount      = (int)$lastItem["count"] + 1;
                    $newItemTotal  = (int)$lastItem["total_price"] + $price;
                    $repcardItem->update((int)$lastItem["id"], [
                        "count"       => $newCount,
                        "total_price" => $newItemTotal,
                    ]);
                } else {
                    // ایجاد آیتم جدید در سبد
                    $repcardItem->create([
                        "card_id"           => $cardId,
                        "vendor_mobile_id"  => $vmobile_id,
                        "price"             => $price,
                        "color_id"          => $color_id,
                        "total_price"       => $price,
                    ]);
                }

                // 6. بروزرسانی قیمت کل سبد
                $repcard->update($cardId, [
                    "total_price" => $currentTotal + $price,
                ]);

                $response->ok()->respond();
                return;
            }

            // 7. اگر سبد قبلاً وجود نداشت، بسازید
            $newCardId = $repcard->create([
                "user_id"     => $user_id,
                "ip"          => $request::ip(),
                "total_price" => $price,
            ]);

            if (!is_int($newCardId)) {
                $response->serverError("خطا در ایجاد سبد خرید")->respond();
                return;
            }

            $repcardItem->create([
                "card_id"           => $newCardId,
                "vendor_mobile_id"  => $vmobile_id,
                "price"             => $price,
                "color_id"          => $color_id,
                "total_price"       => $price,
            ]);

            $response->ok()->respond();

        } catch (\Throwable $e) {
            // اینجا هم حتی TypeError یا سایر ارورهای PHP را می‌گیرد
            $response->serverError($e->getMessage())->respond();
        }
    }


}