<?php

namespace App\Controllers;

use App\Database\Database;
use App\Core\Http\Request;
use App\Core\Response\Response;
use App\Repositories\AddressRepository;
use App\Repositories\BrandRepository;
use App\Repositories\CardRepository;
use App\Repositories\CardItemRepository;
use App\Repositories\ColorRepository;
use App\Repositories\MobileRepository;
use App\Repositories\MobileImageRepository;
use App\Repositories\OrderRepository;
use App\Repositories\OrderItemRepository;
use App\Repositories\PaymentRepository;
use App\Repositories\UserRepository;
use App\Repositories\VendorRepository;
use App\Repositories\VendorMobileRepository;
use App\Repositories\activeMobile ;

class Apis
{
    // start create
    public function createAddress()
    {
        $response = new Response();
        $request  = new Request();
        $repo     = new AddressRepository();

        try {
            $data = [
                'ostan'     => $request::input('ostan'),
                'shahr'     => $request::input('shahr'),
                'codeposti' => $request::input('codeposti'),
                'adress'    => $request::input('adress'),
                'phone'     => $request::input('phone'),
                'user_id'   => $request::input('user_id'),
            ];
            $id = $repo->create($data);
            $response->ok(['id' => $id]);
        } catch (\Exception $e) {
            $response->serverError($e->getMessage());
        }

        $response->respond();
    }

    public function createBrand()
    {
        $response = new Response();
        $request  = new Request();
        $repo     = new BrandRepository();

        try {
            $name = $request::input('name');
            $id   = $repo->create(['name' => $name]);
            $response->ok(['id' => $id]);
        } catch (\Exception $e) {
            $response->serverError($e->getMessage());
        }

        $response->respond();
    }

    public function createCard()
    {
        $response = new Response();
        $request  = new Request();
        $repo     = new CardRepository();

        try {
            $data = [
                'user_id'     => $request::input('user_id'),
                'ip'          => $request::input('ip'),
                'is_expire'   => $request::input('is_expire'),
                'status'      => $request::input('status'),
                'total_price' => $request::input('total_price'),
            ];
            $id = $repo->create($data);
            $response->ok(['id' => $id]);
        } catch (\Exception $e) {
            $response->serverError($e->getMessage());
        }

        $response->respond();
    }

    public function createCardItem()
    {
        $response = new Response();
        $request  = new Request();
        $repo     = new CardItemRepository();

        try {
            $data = [
                'card_id'          => $request::input('card_id'),
                'vendor_mobile_id' => $request::input('vendor_mobile_id'),
                'price'            => $request::input('price'),
                'count'            => $request::input('count'),
                'total_price'      => $request::input('total_price'),
            ];
            $id = $repo->create($data);
            $response->ok(['id' => $id]);
        } catch (\Exception $e) {
            $response->serverError($e->getMessage());
        }

        $response->respond();
    }

    public function createColor()
    {
        $response = new Response();
        $request  = new Request();
        $repo     = new ColorRepository();

        try {
            $id = $repo->create([
                'name' => $request::input('name'),
                'code' => $request::input('code'),
            ]);
            $response->ok(['id' => $id]);
        } catch (\Exception $e) {
            $response->serverError($e->getMessage());
        }

        $response->respond();
    }

    public function createMobile()
    {
        $response = new Response();
        $request  = new Request();
        $repo     = new MobileRepository();

        try {
            $data = [
                'name'      => $request::input('name'),
                'brand_id'  => $request::input('brand_id'),
                'color_id'  => $request::input('color_id'),
                'ram'       => $request::input('ram'),
                'storage'   => $request::input('storage'),
                'description'=> $request::input('description'),
                'detail'    => $request::input('detail'),
                'image_url' => $request::input('image_url'),
            ];
            $id = $repo->create($data);
            $response->ok(['id' => $id]);
        } catch (\Exception $e) {
            $response->serverError($e->getMessage());
        }

        $response->respond();
    }

    public function createMobileImage()
    {
        $response = new Response();
        $request  = new Request();
        $repo     = new MobileImageRepository();

        try {
            $data = [
                'mobile_id' => $request::input('mobile_id'),
                'image_url' => $request::input('image_url'),
            ];
            $id = $repo->create($data);
            $response->ok(['id' => $id]);
        } catch (\Exception $e) {
            $response->serverError($e->getMessage());
        }

        $response->respond();
    }

    public function createOrder()
    {
        $response = new Response();
        $request  = new Request();
        $repo     = new OrderRepository();

        try {
            $data = [
                'user_id'    => $request::input('user_id'),
                'total_price'=> $request::input('total_price'),
                'adress_id'  => $request::input('adress_id'),
                'status'     => $request::input('status'),
            ];
            $id = $repo->create($data);
            $response->ok(['id' => $id]);
        } catch (\Exception $e) {
            $response->serverError($e->getMessage());
        }

        $response->respond();
    }

    public function createOrderItem()
    {
        $response = new Response();
        $request  = new Request();
        $repo     = new OrderItemRepository();

        try {
            $data = [
                'order_id'         => $request::input('order_id'),
                'vendor_mobile_id' => $request::input('vendor_mobile_id'),
                'price'            => $request::input('price'),
                'count'            => $request::input('count'),
                'total_price'      => $request::input('total_price'),
            ];
            $id = $repo->create($data);
            $response->ok(['id' => $id]);
        } catch (\Exception $e) {
            $response->serverError($e->getMessage());
        }

        $response->respond();
    }

    public function createVendorMobile()
    {
        $response = new Response();
        $request  = new Request();
        $repo     = new VendorMobileRepository();
        session_start();
        try {
            $data = [
                'mobile_id'  => $request::input('mobile_id')?? null ,
                'vendor_id'  => $_SESSION["user"]["id"]?? null ,
                'price'      => $request::input('price') ?? null ,
                'is_off'     => $request::input('is_off') ?? null ,
                'off_persent'=> $request::input('off_persent')?? null ,
                'count'      => $request::input('count')?? null ,

            ];
            $id = $repo->create($data);
            $response->ok($request::params());
        } catch (\Exception $e) {
            $response->serverError($e->getMessage());
        }

        $response->respond();
    }
    // end create
    public function viewALLMobile()
    {
        $response = new Response();
        $request  = new Request();
        $mobile     = new MobileRepository();
        $vmobile = new VendorMobileRepository();
        $brand = new BrandRepository();
        $activeMobile = new activeMobile();
        try {

            $data = $activeMobile->get($request::input("query")??null,$request::input("limit")??null,$request::input("offset")??null);
            $response->ok($data);
        } catch (\Exception $e) {
            $response->serverError($e->getMessage());
        }
        $response->respond();
    }



}