<!DOCTYPE html>
<html direction="rtl" dir="rtl" style="direction: rtl">
<!--begin::Head-->
<head>
    <title>افزودن محصول | A38</title>
    <meta charset="utf-8"/>
    <base href="<?php echo $_ENV["BASE_URL"] ?>" >
    <meta name="description"
          content="The most advanced Bootstrap 5 Admin Theme with 40 unique prebuilt layouts on Themeforest trusted by 100,000 beginners and professionals. Multi-demo, Dark Mode, RTL support and complete React, Angular, Vue, Asp.Net Core, Rails, Spring, Blazor, Django, Express.js, Node.js, Flask, Symfony & Laravel versions. Grab your copy now and get life-time updates for free."/>
    <meta name="keywords"
          content="metronic, bootstrap, bootstrap 5, angular, VueJs, React, Asp.Net Core, Rails, Spring, Blazor, Django, Express.js, Node.js, Flask, Symfony & Laravel starter kits, admin themes, web design, figma, web development, free templates, free admin themes, bootstrap theme, bootstrap template, bootstrap dashboard, bootstrap dak mode, bootstrap button, bootstrap datepicker, bootstrap timepicker, fullcalendar, datatables, flaticon"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <meta property="og:locale" content="en_US"/>
    <meta property="og:type" content="article"/>
    <meta property="og:title" content=" آک گارانتی"/>
    <meta property="og:url" content="https://keenthemes.com/metronic"/>
    <meta property="og:site_name" content="Metronic by Keenthemes"/>
    <link rel="canonical" href="http://preview.keenthemes.comindex.html"/>
    <link rel="shortcut icon" href="assets/media/my_media/logo.png"/>
    <!--begin::Fonts(mandatory for all pages)-->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700"/>
    <link rel="stylesheet" href="assets/fonts/Vazirmatn-font-face.css">
     
    <!--end::Fonts-->
    <!--begin::Vendor Stylesheets(used for this page only)-->
    <link href="assets/plugins/custom/fullcalendar/fullcalendar.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
    <!--end::Vendor Stylesheets-->
    <!--begin::Global Stylesheets Bundle(mandatory for all pages)-->
    <link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="assets/css/style.bundle.css" rel="stylesheet" type="text/css"/>
    <script>// Frame-busting to prevent site from being loaded within a frame without permission (click-jacking) if (window.top != window.self) { window.top.location.replace(window.self.location.href); }</script>
</head>
<style>
    body {
         font-family: 'Vazirmatn', sans-serif;
    }
    .color-swatch {
        display: inline-block;
        width: 16px;
        height: 16px;
        border-radius: 50%;
        margin-right: 8px;
        border: 1px solid #ddd;
    }



</style>
<!--end::Head-->
<!--begin::Body-->
<body id="kt_app_body" data-kt-app-layout="dark-sidebar" data-kt-app-header-fixed="true"
      data-kt-app-sidebar-enabled="true" data-kt-app-sidebar-fixed="true" data-kt-app-sidebar-hoverable="true"
      data-kt-app-sidebar-push-header="true" data-kt-app-sidebar-push-toolbar="true"
      data-kt-app-sidebar-push-footer="true" data-kt-app-toolbar-enabled="true" class="app-default">
<!--begin::Theme mode setup on page load-->
<script>var defaultThemeMode = "light";
    var themeMode;
    if (document.documentElement) {
        if (document.documentElement.hasAttribute("data-bs-theme-mode")) {
            themeMode = document.documentElement.getAttribute("data-bs-theme-mode");
        } else {
            if (localStorage.getItem("data-bs-theme") !== null) {
                themeMode = localStorage.getItem("data-bs-theme");
            } else {
                themeMode = defaultThemeMode;
            }
        }
        if (themeMode === "system") {
            themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light";
        }
        document.documentElement.setAttribute("data-bs-theme", themeMode);
    }</script>
<!--end::Theme mode setup on page load-->
<!--begin::App-->
<div class="d-flex flex-column flex-root app-root" id="kt_app_root">
    <!--begin::Page-->
    <div class="app-page flex-column flex-column-fluid" id="kt_app_page">
        <!--begin::Header-->
        <div id="kt_app_header" class="app-header" data-kt-sticky="true"
             data-kt-sticky-activate="{default: true, lg: true}" data-kt-sticky-name="app-header-minimize"
             data-kt-sticky-offset="{default: '200px', lg: '0'}" data-kt-sticky-animation="false">
            <!--begin::Header container-->
            <div class="app-container container-fluid d-flex align-items-stretch justify-content-between"
                 id="kt_app_header_container">
                <!--begin::Sidebar mobile toggle-->
                <div class="d-flex align-items-center d-lg-none ms-n3 me-1 me-md-2" title="Show sidebar menu">
                    <div class="btn btn-icon btn-active-color-primary w-35px h-35px" id="kt_app_sidebar_mobile_toggle">
                        <i class="ki-duotone ki-abstract-14 fs-2 fs-md-1">
                            <span class="path1"></span>
                            <span class="path2"></span>
                        </i>
                    </div>
                </div>
                <!--end::Sidebar mobile toggle-->
                <!--begin::Mobile logo-->
                <div class="d-flex align-items-center flex-grow-1 flex-lg-grow-0">
                    <a href="index.html" class="d-lg-none">
                        <img alt="Logo" src="assets/media/my_media/logo.png" class="h-30px"/>
                    </a>
                </div>
                <!--end::Mobile logo-->
                <!--begin::Header wrapper-->
                <div class="d-flex align-items-stretch justify-content-between flex-lg-grow-1"
                     id="kt_app_header_wrapper">
                    <!--begin::Menu wrapper-->
                    <div class="app-header-menu app-header-mobile-drawer align-items-stretch" data-kt-drawer="true"
                         data-kt-drawer-name="app-header-menu" data-kt-drawer-activate="{default: true, lg: false}"
                         data-kt-drawer-overlay="true" data-kt-drawer-width="250px" data-kt-drawer-direction="end"
                         data-kt-drawer-toggle="#kt_app_header_menu_toggle" data-kt-swapper="true"
                         data-kt-swapper-mode="{default: 'append', lg: 'prepend'}"
                         data-kt-swapper-parent="{default: '#kt_app_body', lg: '#kt_app_header_wrapper'}">
                        <!--begin::Menu-->
                        <div class="menu menu-rounded menu-column menu-lg-row my-5 my-lg-0 align-items-stretch fw-semibold px-2 px-lg-0"
                             id="kt_app_header_menu" data-kt-menu="true">
                        </div>
                        <!--end::Menu-->
                    </div>
                    <!--end::Menu wrapper-->
                    <!--begin::Navbar-->
                    <div class="app-navbar flex-shrink-0">
                        <!--begin::User menu-->
                        <div class="app-navbar-item ms-1 ms-md-4" id="kt_header_user_menu_toggle">
                            <!--begin::Menu wrapper-->
                            <div class="cursor-pointer symbol symbol-35px"
                                 data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-attach="parent"
                                 data-kt-menu-placement="bottom-end">
                                <img src="<?php echo "../".$user["pic"] ?? "assets/media/avatars/blank.png" ?>" class="rounded-3" alt="user"/>
                            </div>
                            <!--begin::User account menu-->
                            <div  class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg menu-state-color fw-semibold py-4 fs-6 w-275px"
                                  data-kt-menu="true">
                                <!--begin::Menu item-->
                                <div class="menu-item px-3">
                                    <div class="menu-content d-flex align-items-center px-3">
                                        <!--begin::Avatar-->
                                        <div class="symbol symbol-50px me-5">
                                            <img alt="Logo" src="<?php echo "../".$user["pic"] ?? "assets/media/avatars/blank.png" ?>"/>
                                        </div>
                                        <!--end::Avatar-->
                                        <!--begin::Username-->
                                        <div class="d-flex flex-column">
                                            <div class="fw-bold d-flex align-items-center fs-6"><?php echo $user["name"] ?? "نام و نام خانوادگی" ?>
                                            </div>
                                        </div>
                                        <!--end::Username-->
                                    </div>
                                </div>
                                <!--end::Menu item-->
                                <!--begin::Menu separator-->
                                <div class="separator my-2"></div>
                                <!--end::Menu separator-->
                                <!--begin::Menu item-->
                                <div class="menu-item px-5 my-1">
                                    <a href="/admin/setting" class="menu-link px-5">تنظیمات اکانت</a>
                                </div>
                                <!--end::Menu item-->
                                <!--begin::Menu item-->
                                <div class="menu-item px-5" data-kt-menu-trigger="{default: 'click', lg: 'hover'}"
                                     data-kt-menu-placement="left-start" data-kt-menu-offset="-15px, 0">
                                    <a href="#" class="menu-link px-5">
												<span class="menu-title position-relative">مود سایت
												<span class="ms-5 position-absolute translate-middle-y top-50 end-0">
													<i class="ki-duotone ki-night-day theme-light-show fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
														<span class="path3"></span>
														<span class="path4"></span>
														<span class="path5"></span>
														<span class="path6"></span>
														<span class="path7"></span>
														<span class="path8"></span>
														<span class="path9"></span>
														<span class="path10"></span>
													</i>
													<i class="ki-duotone ki-moon theme-dark-show fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
													</i>
												</span></span>
                                    </a>
                                    <!--begin::Menu-->
                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-title-gray-700 menu-icon-gray-500 menu-active-bg menu-state-color fw-semibold py-4 fs-base w-150px"
                                         data-kt-menu="true" data-kt-element="theme-mode-menu">
                                        <!--begin::Menu item-->
                                        <div class="menu-item px-3 my-0">
                                            <a href="#" class="menu-link px-3 py-2" data-kt-element="mode"
                                               data-kt-value="light">
														<span class="menu-icon" data-kt-element="icon">
															<i class="ki-duotone ki-night-day fs-2">
																<span class="path1"></span>
																<span class="path2"></span>
																<span class="path3"></span>
																<span class="path4"></span>
																<span class="path5"></span>
																<span class="path6"></span>
																<span class="path7"></span>
																<span class="path8"></span>
																<span class="path9"></span>
																<span class="path10"></span>
															</i>
														</span>
                                                <span class="menu-title">روشن</span>
                                            </a>
                                        </div>
                                        <!--end::Menu item-->
                                        <!--begin::Menu item-->
                                        <div class="menu-item px-3 my-0">
                                            <a href="#" class="menu-link px-3 py-2" data-kt-element="mode"
                                               data-kt-value="dark">
														<span class="menu-icon" data-kt-element="icon">
															<i class="ki-duotone ki-moon fs-2">
																<span class="path1"></span>
																<span class="path2"></span>
															</i>
														</span>
                                                <span class="menu-title">تاریک</span>
                                            </a>
                                        </div>
                                        <!--end::Menu item-->
                                    </div>
                                    <!--end::Menu-->
                                </div>
                                <!--end::Menu item-->
                                <!--begin::Menu item-->
                                <div class="menu-item px-5">
                                    <a href="/" class="menu-link px-5">خروج</a>
                                </div>
                                <!--end::Menu item-->
                            </div>
                            <!--end::User account menu-->
                            <!--end::Menu wrapper-->
                        </div>
                        <!--end::User menu-->
                        <!--begin::Header menu toggle-->
                        <div class="app-navbar-item d-lg-none ms-2 me-n2" title="Show header menu">
                            <div class="btn btn-flex btn-icon btn-active-color-primary w-30px h-30px"
                                 id="kt_app_header_menu_toggle">
                                <i class="ki-duotone ki-element-4 fs-1">
                                    <span class="path1"></span>
                                    <span class="path2"></span>
                                </i>
                            </div>
                        </div>
                        <!--end::Header menu toggle-->
                        <!--begin::Aside toggle-->
                        <!--end::Header menu toggle-->
                    </div>
                    <!--end::Navbar-->
                </div>
                <!--end::Header wrapper-->
            </div>
            <!--end::Header container-->
        </div>
        <!--end::Header-->
        <!--begin::Wrapper-->
        <div class="app-wrapper flex-column flex-row-fluid" id="kt_app_wrapper">
            <!--begin::Sidebar-->
            <div id="kt_app_sidebar" class="app-sidebar flex-column" data-kt-drawer="true"
                 data-kt-drawer-name="app-sidebar" data-kt-drawer-activate="{default: true, lg: false}"
                 data-kt-drawer-overlay="true" data-kt-drawer-width="225px" data-kt-drawer-direction="start"
                 data-kt-drawer-toggle="#kt_app_sidebar_mobile_toggle">
                <!--begin::Logo-->
                <div class="app-sidebar-logo px-6" id="kt_app_sidebar_logo">
                    <!--begin::Logo image-->
                    <a href="/admin">
                        <img alt="Logo" src="assets/media/my_media/logo3.png"
                             class="h-55px app-sidebar-logo-default"/>
                        <img alt="Logo" src="assets/media/my_media/logo.png"
                             class="h-30px app-sidebar-logo-minimize"/>
                    </a>
                    <!--end::Logo image-->
                    <!--begin::Sidebar toggle-->
                    <!--begin::Minimized sidebar setup:
                                        if (isset($_COOKIE["sidebar_minimize_state"]) && $_COOKIE["sidebar_minimize_state"] === "on") {
                                        1. "src/js/layout/sidebar.js" adds "sidebar_minimize_state" cookie value to save the sidebar minimize state.
                                        2. Set data-kt-app-sidebar-minimize="on" attribute for body tag.
                                        3. Set data-kt-toggle-state="active" attribute to the toggle element with "kt_app_sidebar_toggle" id.
                                        4. Add "active" class to to sidebar toggle element with "kt_app_sidebar_toggle" id.
                                    }
                                -->
                    <div id="kt_app_sidebar_toggle"
                         class="app-sidebar-toggle btn btn-icon btn-shadow btn-sm btn-color-muted btn-active-color-primary h-30px w-30px position-absolute top-50 start-100 translate-middle rotate"
                         data-kt-toggle="true" data-kt-toggle-state="active" data-kt-toggle-target="body"
                         data-kt-toggle-name="app-sidebar-minimize">
                        <i class="ki-duotone ki-black-left-line fs-3 rotate-180">
                            <span class="path1"></span>
                            <span class="path2"></span>
                        </i>
                    </div>
                    <!--end::Sidebar toggle-->
                </div>
                <!--end::Logo-->
                <!--begin::sidebar menu-->
                <div class="app-sidebar-menu overflow-hidden flex-column-fluid">
                    <!--begin::Menu wrapper-->
                    <div id="kt_app_sidebar_menu_wrapper" class="app-sidebar-wrapper">
                        <!--begin::Scroll wrapper-->
                        <div id="kt_app_sidebar_menu_scroll" class="scroll-y my-5 mx-3" data-kt-scroll="true"
                             data-kt-scroll-activate="true" data-kt-scroll-height="auto"
                             data-kt-scroll-dependencies="#kt_app_sidebar_logo, #kt_app_sidebar_footer"
                             data-kt-scroll-wrappers="#kt_app_sidebar_menu" data-kt-scroll-offset="5px"
                             data-kt-scroll-save-state="true">
                            <!--begin::Menu-->
                            <div class="menu menu-column menu-rounded menu-sub-indention fw-semibold fs-6"
                                 id="#kt_app_sidebar_menu" data-kt-menu="true" data-kt-menu-expand="false">
                                <!--begin:Menu item-->
                                <div data-kt-menu-trigger="click" class=" menu-item menu-accordion">
                                    <!--begin:Menu link-->
                                    <a href="/adminshop/dashboard" class="menu-link">
												<span class="menu-icon">
													<i class="ki-duotone ki-element-11 fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
														<span class="path3"></span>
														<span class="path4"></span>
													</i>
												</span>
                                        <span class="menu-title fw-bold fs-4 ">فروشندگان</span>
                                    </a>
                                    <!--end:Menu link-->
                                </div>
                                <!--end:Menu item-->
                                <!--begin:Menu item-->
                                <div data-kt-menu-trigger="click" class=" menu-item menu-accordion">
                                    <!--begin:Menu link-->
                                    <a href="/adminshop/products" class="menu-link">
												<span class="menu-icon">
													<i class="ki-duotone ki-element-11 fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
														<span class="path3"></span>
														<span class="path4"></span>
													</i>
												</span>
                                        <span class="menu-title fw-bold fs-4 ">محصولات</span>
                                    </a>
                                    <!--end:Menu link-->
                                </div>
                                <!--end:Menu item-->
                                <!--begin:Menu item-->
                                <div data-kt-menu-trigger="click" class=" menu-item menu-accordion">
                                    <!--begin:Menu link-->
                                    <a href="/adminshop/my-products" class="menu-link">
												<span class="menu-icon">
													<i class="ki-duotone ki-element-11 fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
														<span class="path3"></span>
														<span class="path4"></span>
													</i>
												</span>
                                        <span class="menu-title fw-bold fs-4 ">محصولات من</span>
                                    </a>
                                    <!--end:Menu link-->
                                </div>
                                <!--end:Menu item-->
                                <!--begin:Menu item-->
                                <div data-kt-menu-trigger="click" class=" menu-item menu-accordion">
                                    <!--begin:Menu link-->
                                    <a href="/adminshop/order" class="menu-link">
												<span class="menu-icon">
													<i class="ki-duotone ki-element-11 fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
														<span class="path3"></span>
														<span class="path4"></span>
													</i>
												</span>
                                        <span class="menu-title fw-bold fs-4 ">سفارش ها</span>
                                    </a>
                                    <!--end:Menu link-->
                                </div>
                                <!--end:Menu item-->
                                <!--begin:Menu item-->
                                <div data-kt-menu-trigger="click" class=" menu-item menu-accordion">
                                    <!--begin:Menu link-->
                                    <a href="/adminshop/users" class="menu-link">
												<span class="menu-icon">
													<i class="ki-duotone ki-element-11 fs-2">
														<span class="path1"></span>
														<span class="path2"></span>
														<span class="path3"></span>
														<span class="path4"></span>
													</i>
												</span>
                                        <span class="menu-title fw-bold fs-4 ">کاربران</span>
                                    </a>
                                    <!--end:Menu link-->
                                </div>
                                <!--end:Menu item-->
                            </div>
                            <!--end::Menu-->
                        </div>
                        <!--end::Scroll wrapper-->
                    </div>
                    <!--end::Menu wrapper-->
                </div>
                <!--end::sidebar menu-->
                <!--begin::Footer-->
                <!--end::Footer-->
            </div>
            <!--end::Sidebar-->
            <!--begin::Main-->
            <div class="app-main flex-column flex-row-fluid" id="kt_app_main">
                <!--begin::Content wrapper-->
                <div class="d-flex flex-column flex-column-fluid">
                    <!--begin::Toolbar-->
                    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
                        <!--begin::Toolbar container-->
                        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
                            <!--begin::Page title-->
                            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                                <!--begin::Title-->
                                <h1 class="page-heading d-flex text-gray-900 fw-bold fs-1hx flex-column justify-content-center my-0">
                                    افزودن محصول</h1>
                                <!--end::Title-->
                                <!--begin::Breadcrumb-->
                                <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-5 my-0 pt-1">
                                    <!--begin::Item-->
                                    <li class="breadcrumb-item text-muted">
                                        <a href="/admin"
                                           class="text-muted text-hover-primary">داشبورد</a>
                                    </li>
                                    <!--end::Item-->
                                    <!--begin::Item-->
                                    <li class="breadcrumb-item">
                                        <span class="bullet bg-gray-500 w-5px h-2px"></span>
                                    </li>
                                    <!--end::Item-->
                                    <!--begin::Item-->
                                    <li class="breadcrumb-item text-muted">محصولات</li>
                                    <!--end::Item-->
                                </ul>
                                <!--end::Breadcrumb-->
                            </div>
                            <!--end::Page title-->
                        </div>
                        <!--end::Toolbar container-->
                    </div>
                    <!--end::Toolbar-->
                    <!--begin::Content-->
                    <div id="kt_app_content" class="app-content flex-column-fluid">
                        <!--begin::Content container-->
                        <div id="kt_app_content_container" class="app-container container-fluid">
                            <!--begin::Form-->
                            <div class="form d-flex flex-column flex-lg-row" >
                                <!--begin::Main column-->
                                <div  class="d-flex flex-column flex-row-fluid gap-7 gap-lg-10">
                                    <!--begin::Tab content-->
                                    <div class="tab-content">
                                        <!--begin::Tab pane-->
                                        <div class="tab-pane fade show active" id="kt_ecommerce_add_product_general" role="tab-panel">
                                            <div id="pricingSection" class="d-flex flex-column gap-7 gap-lg-10">
                                                <!--begin::Order details-->
                                                <div class="card card-flush py-4">
                                                    <!--begin::Card header-->
                                                    <div class="card-header">
                                                        <div class="card-title">
                                                            <h2>انتخاب محصول</h2>
                                                        </div>
                                                    </div>
                                                    <!--end::Card header-->
                                                    <!--begin::Card body-->
                                                    <div class="card-body pt-0">
                                                        <div class="d-flex flex-column gap-10">
                                                            <div class="row " >
                                                                <div class="col-md-4" >
                                                                    <div class="row mb-5 " >
                                                                        <div class="col-md-12" >
                                                                            <!--begin::Label-->
                                                                            <label class="form-label">برند</label>
                                                                            <!--end::Label-->
                                                                            <!--begin::Select2-->
                                                                            <select id="brand222" class="form-select"  >
                                                                                <option></option>
                                                                                <?php foreach ($brands as $brand) : ?>
                                                                                    <option value="<?php echo $brand["id"] ?>"><?php echo $brand["name"] ?></option>
                                                                                <?php endforeach; ?>
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-md-12" >
                                                                            <!--begin::Label-->
                                                                            <label class="form-label">رم</label>
                                                                            <!--end::Label-->
                                                                            <!--begin::Select2-->
                                                                            <select id="ram" class="form-select mb-2"  >
                                                                                <option></option>
                                                                                <?php foreach ($rams as $ram) : ?>
                                                                                    <option value="<?php echo $ram["ram"] ?>"><?php echo $ram["ram"] ?></option>
                                                                                <?php endforeach; ?>
                                                                            </select>
                                                                            <!--end::Select2-->
                                                                        </div>
                                                                        <div class="col-md-12" >
                                                                            <!--begin::Label-->
                                                                            <label class="form-label">حافظه</label>
                                                                            <!--end::Label-->
                                                                            <!--begin::Select2-->
                                                                            <select id="storage" class="form-select mb-2"  >
                                                                                <option></option>
                                                                                <?php foreach ($storages as $ram) : ?>
                                                                                    <option value="<?php echo $ram["storage"] ?>"><?php echo $ram["storage"] ?></option>
                                                                                <?php endforeach; ?>
                                                                            </select>
                                                                            <!--end::Select2-->
                                                                        </div>
                                                                        <div class=" col-md-12">
                                                                            <!--begin::Label-->
                                                                            <label class="form-label">نام محصول</label>
                                                                            <!--end::Label-->
                                                                            <div class="d-flex align-items-center " >
                                                                                <i class="ki-duotone ki-magnifier fs-3 position-absolute ms-4">
                                                                                    <span class="path1"></span>
                                                                                    <span class="path2"></span>
                                                                                </i>
                                                                                <input type="text" data-kt-ecommerce-edit-order-filter="search" class="form-control form-control  ps-12" placeholder="Search Products" />
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                                <div class="col-md-8" >
                                                                    <!--begin::Table-->
                                                                    <table class="table align-middle table-row-dashed fs-6 gy-5  " id="search_product">
                                                                        <thead>
                                                                        <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0">
                                                                            <th class="w-25px pe-2"></th>
                                                                            <th class="text-start  min-w-200px">محصول</th>
                                                                            <th class="text-start   min-w-100px">رم</th>
                                                                            <th class="text-start   min-w-100px">حافظه</th>
                                                                        </tr>
                                                                        </thead>
                                                                        <tbody class="fw-semibold text-gray-600">
                                                                        <tr>
                                                                            <td>
                                                                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                                                                    <input class="form-check-input" name="mobile_id" type="radio" value="1" />
                                                                                </div>
                                                                            </td>
                                                                            <td>
                                                                                <div class="d-flex align-items-center" data-kt-ecommerce-edit-order-filter="product" data-kt-ecommerce-edit-order-id="product_1">
                                                                                    <!--begin::Thumbnail-->
                                                                                    <a  class="symbol symbol-50px">
                                                                                        <span class="symbol-label" style="background-image:url(assets/media//stock/ecommerce/1.png);"></span>
                                                                                    </a>
                                                                                    <!--end::Thumbnail-->
                                                                                    <div class="ms-5">
                                                                                        <!--begin::Title-->
                                                                                        <a  class="text-gray-800 text-hover-primary fs-5 fw-bold">Product 1</a>
                                                                                        <!--end::Title-->
                                                                                        <!--begin::SKU-->
                                                                                        <div class="text-muted fs-7">brand</div>
                                                                                        <!--end::SKU-->
                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                            <td class="text-start pe-5" >12 </td>
                                                                            <td class="text-start pe-5" >512</td>
                                                                        </tr>
                                                                        </tbody>
                                                                    </table>
                                                                    <!--end::Table-->
                                                                </div>
                                                            </div>


                                                        </div>
                                                    </div>
                                                    <!--end::Card header-->
                                                </div>
                                                <!--end::Order details-->
                                                <!--begin::Pricing-->
                                                <div class="card card-flush py-4">
                                                    <!--begin::Card header-->
                                                    <div class="card-header">
                                                        <div class="card-title">
                                                            <h2>اطلاعات</h2>
                                                        </div>
                                                    </div>
                                                    <!--end::Card header-->
                                                    <!--begin::Card body-->
                                                    <div class="card-body pt-0">

                                                        <div class="row" >
                                                            <div class="col-md-6">
                                                                <!--begin::Input group-->
                                                                <div class="mb-10 fv-row">
                                                                    <!--begin::Label-->
                                                                    <label class="required form-label">قیمت پایه</label>
                                                                    <!--end::Label-->
                                                                    <!--begin::Input-->
                                                                    <input type="text" name="price" class="form-control mb-2" placeholder="Product price" value="" />
                                                                    <!--end::Input-->
                                                                    <!--begin::Description-->
                                                                    <div class="text-muted fs-7">Set the product price.</div>
                                                                    <!--end::Description-->
                                                                </div>
                                                                <!--end::Input group-->
                                                                <!--begin::Input group-->
                                                                <div class="fv-row mb-10">
                                                                    <!--begin::Label-->
                                                                    <label class="fs-6 fw-semibold mb-2">تخفیف
																	</span></label>
                                                                    <!--End::Label-->
                                                                    <!--begin::Row-->
                                                                    <div class="row row-cols-1 row-cols-md-3 row-cols-lg-1 row-cols-xl-3 g-9" data-kt-buttons="true" data-kt-buttons-target="[data-kt-button='true']">
                                                                        <!--begin::Col-->
                                                                        <div class="col-md-6">
                                                                            <!--begin::Option-->
                                                                            <label class="btn btn-outline btn-outline-dashed btn-active-light-primary active d-flex text-start p-6" data-kt-button="true">
                                                                                <!--begin::Radio-->
                                                                                <span class="form-check form-check-custom form-check-solid form-check-sm align-items-start mt-1">
																					<input class="form-check-input" onchange="hidden_off()" type="radio" name="discount_option" value="0" checked="checked" />
																				</span>
                                                                                <!--end::Radio-->
                                                                                <!--begin::Info-->
                                                                                <span class="ms-5">
																					<span class="fs-4 fw-bold text-gray-800 d-block">بدون تخفیف</span>
																				</span>
                                                                                <!--end::Info-->
                                                                            </label>
                                                                            <!--end::Option-->
                                                                        </div>
                                                                        <!--end::Col-->
                                                                        <!--begin::Col-->
                                                                        <div class="col-md-6">
                                                                            <!--begin::Option-->
                                                                            <label class="btn btn-outline btn-outline-dashed btn-active-light-primary d-flex text-start p-6" data-kt-button="true">
                                                                                <!--begin::Radio-->
                                                                                <span class="form-check form-check-custom form-check-solid form-check-sm align-items-start mt-1">
																					<input class="form-check-input" onchange="hidden_off()" type="radio" name="discount_option" value="1" />
																				</span>
                                                                                <!--end::Radio-->
                                                                                <!--begin::Info-->
                                                                                <span class="ms-5">
																					<span class="fs-4 fw-bold text-gray-800 d-block">دارای تخفیف</span>
																				</span>
                                                                                <!--end::Info-->
                                                                            </label>
                                                                            <!--end::Option-->
                                                                        </div>
                                                                        <!--end::Col-->
                                                                    </div>
                                                                    <!--end::Row-->
                                                                </div>
                                                                <!--end::Input group-->
                                                                <!--begin::Input group-->
                                                                <div class="row hidden fade " id="off_input"  >
                                                                    <div class="col-md-6" >
                                                                        <!--begin::Label-->
                                                                        <label class="required form-label">درصد تخفیف</label>
                                                                        <!--end::Label-->
                                                                        <!--begin::Input-->
                                                                        <input type="number" name="off_pecent" class="form-control mb-2" placeholder="22" value="" />
                                                                        <!--end::Input-->
                                                                    </div>
                                                                    <div class="col-md-6" >
                                                                        <!--begin::Label-->
                                                                        <label class="required form-label">تاریخ انقضا</label>
                                                                        <!--end::Label-->
                                                                        <!--begin::Input-->
                                                                        <input id="tarikh" readonly name="date_off" type="text" value="" class="form-control form-control-solid" placeholder="تاریخ انقظا" required>
                                                                        <input type="hidden" id="tarikhAlt" name="activation_start_date">
                                                                        <!--end::Input-->
                                                                    </div>
                                                                </div>
                                                                <!--end::Input group-->
                                                                <div>
                                                                    
                                                                </div>


                                                            </div>

                                                            <div class="col-md-6 mt-10">
                                                                <div class="form-group">
                                                                    <label class="col-form-label required">رنگ محصول</label>

                                                                    <!-- Dropdown اصلی -->
                                                                    <div class="dropdown">
                                                                        <!-- Toggler -->
                                                                        <div
                                                                                id="colorDropdown"
                                                                                class="form-control dropdown-toggle d-flex align-items-center justify-content-between"
                                                                                role="button"
                                                                                data-toggle="dropdown"
                                                                                aria-haspopup="true"
                                                                                aria-expanded="false"
                                                                                style="cursor: pointer;"
                                                                        >
      <span
              id="colorDropdownSwatch"
              style="display: none; width: 16px; height: 16px; border-radius: 50%; border: 1px solid #ddd;"
      ></span>
                                                                            <span id="colorDropdownLabel">انتخاب رنگ</span>
                                                                        </div>

                                                                        <!-- منوی کشویی -->
                                                                        <div
                                                                                class="dropdown-menu w-100"
                                                                                id="colorDropdownMenu"
                                                                                aria-labelledby="colorDropdown"
                                                                                style="max-height: 200px; overflow-y: auto;"
                                                                        >
                                                                            <!-- گزینه‌های از پیش‌تعریف‌شده -->
                                                                            <?php foreach($colors as $c): ?>
                                                                                <button
                                                                                        type="button"
                                                                                        class="dropdown-item d-flex align-items-center color-item"
                                                                                        data-value="<?= $c['id'] ?>"
                                                                                        data-name="<?= htmlspecialchars($c['name']) ?>"
                                                                                        data-hex="<?= $c['code'] ?>"
                                                                                >
                                                                                    <span class="color-swatch mr-2" style="background: <?= $c['code'] ?>; width:16px; height:16px; border-radius:50%; border:1px solid #ddd;"></span>
                                                                                    <?= htmlspecialchars($c['name']) ?>
                                                                                </button>
                                                                            <?php endforeach; ?>

                                                                            <div class="dropdown-divider"></div>

                                                                            <!-- دکمه‌ی باز کردن فرم رنگ دلخواه -->
                                                                            <button
                                                                                    type="button"
                                                                                    class="dropdown-item text-primary small"
                                                                                    id="showCustomColor"
                                                                            >
                                                                                <i class="la la-paint-brush"></i>
                                                                                رنگ دلخواه ندارید؟
                                                                            </button>
                                                                        </div>
                                                                    </div>

                                                                    <!-- فرم رنگ دلخواه -->
                                                                    <div class="mt-3 collapse" id="customColorSection">
                                                                        <div class="form-group">
                                                                            <label for="customColorName" class="col-form-label">نام رنگ دلخواه</label>
                                                                            <input
                                                                                    type="text"
                                                                                    id="customColorName"
                                                                                    name="name"
                                                                                    class="form-control form-control-solid"
                                                                                    placeholder="مثلاً «آبی آسمانی»"
                                                                            >
                                                                        </div>

                                                                        <div class="input-group input-group-solid">
                                                                            <input
                                                                                    type="color"
                                                                                    id="customColorPicker"
                                                                                    name="code"
                                                                                    class="form-control p-0"
                                                                                    value="#000000"
                                                                                    style="max-width:56px;"
                                                                            >
                                                                            <input
                                                                                    type="text"
                                                                                    id="customColorText"
                                                                                    class="form-control form-control-solid ml-2"
                                                                                    placeholder="#ff0000 یا rgb(255,0,0)"
                                                                            >
                                                                            <div class="input-group-append">
                                                                                <button
                                                                                        class="btn btn-primary"
                                                                                        type="button"
                                                                                        id="applyCustomColor"
                                                                                >
                                                                                    اعمال رنگ
                                                                                </button>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <!-- فیلد مخفی برای ارسال شناسه رنگ -->
                                                                    <input type="hidden" name="color_code" id="color_code">
                                                                <div class="row mt-10 ">
                                                                    <div class="col-md-12" >
                                                                        <!--begin::Label-->
                                                                        <label class="required form-label">تعداد موجودی انبار</label>
                                                                        <!--end::Label-->
                                                                        <!--begin::Input-->
                                                                        <input type="number" name="count" class="form-control mb-2" placeholder="22" value="" />
                                                                        <!--end::Input-->
                                                                    </div>
                                                                </div>

                                                                </div>






                                                    </div>
                                                    <!--end::Card header-->
                                                </div>
                                                <!--end::Pricing-->
                                            </div>
                                            </div>
                                        </div>
                                        <!--end::Tab pane-->
                                    </div>
                                    <!--end::Tab content-->
                                    <div class="d-flex justify-content-end">
                                        <!--begin::Button-->
                                        <a href="" id="kt_ecommerce_add_product_cancel" class="btn btn-light me-5">بیخیال</a>
                                        <!--end::Button-->
                                        <!--begin::Button-->
                                        <button onclick="create()" type="submit" id="kt_ecommerce_add_product_submit" class="btn btn-primary">
                                            <span class="indicator-label">تایید</span>
                                            <span class="indicator-progress">لطفا صبر کنید...
													<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                                        </button>
                                        <!--end::Button-->
                                    </div>
                                </div>
                                <!--end::Main column-->
                            </div>
                            <!--end::Form-->
                        </div>
                        <!--end::Content container-->
                    </div>
                    <!--end::Content-->
                </div>
                <!--end::Content wrapper-->
            </div>
            <!--end:::Main-->
        </div>
        <!--end::Wrapper-->
    </div>
    <!--end::Page-->
</div>
<!--end::App-->

<!--end::Modal - view user-->
<!--begin::Javascript-->
<!--begin::Global Javascript Bundle(mandatory for all pages)-->
<script src="assets/js/custom/apps/ecommerce/catalog/save-product.js"></script>
    <script src="assets/plugins/global/plugins.bundle.min.js"></script>
    <script src="assets/js/scripts.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
    <!--end::Global Javascript Bundle-->
<!--begin::Vendors Javascript(used for this page only)-->
<script src="assets/plugins/custom/datatables/datatables.bundle.js"></script>
<!--end::Vendors Javascript-->
<!--begin::Custom Javascript(used for this page only)-->
<script src="assets/plugins/custom/formrepeater/formrepeater.bundle.js"></script>
<script>
    $('#kt_docs_repeater_basic').repeater({
        initEmpty: false,

        defaultValues: {
            'text-input': 'foo'
        },

        show: function () {
            $(this).slideDown();
        },

        hide: function (deleteElement) {
            $(this).slideUp(deleteElement);
        }
    });

</script>
<script src="assets/js/custom/apps/ecommerce/catalog/save-product.js"></script>
<script src="assets/js/widgets.bundle.js"></script>
<script src="assets/js/custom/widgets.js"></script>
<script src="assets/js/custom/apps/chat/chat.js"></script>
<script src="assets/js/custom/utilities/modals/upgrade-plan.js"></script>
<script src="assets/js/custom/utilities/modals/create-app.js"></script>
<script src="assets/js/custom/utilities/modals/users-search.js"></script>
<script src="assets/js/myjs/ApiClient.js"></script>
<link rel="stylesheet" href="assets/date/persian-datepicker-0.4.5.min.css">
<script src="assets/date/persian-date-0.1.8.min.js"></script>
<script src="assets/date/persian-datepicker-0.4.5.min.js"></script>
<script>
    $(document).ready(function () {
        $("#tarikh").persianDatepicker({
            initialValue: false,
            altField: "#tarikhAlt",
            altFormat: "YYYY/MM/DD",
            format: "YYYY/MM/DD",
            observer: true,
            autoClose: true,
            toolbox: { enabled: false },
        });

    });
</script>

<script>
    "use strict";

    var KTProductSearch = {
        init: function() {
            const tableEl = document.getElementById("search_product");
            if (!tableEl) return;

            const brandFilter   = $("#brand222");
            const ramFilter     = $("#ram");
            const storageFilter = $("#storage");
            const searchInput   = $('[data-kt-ecommerce-edit-order-filter="search"]');

            const table = $(tableEl).DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: 'api/search/mobile',
                    type: 'GET',
                    data: function(d) {
                        d.brand   = brandFilter.val();
                        d.ram     = ramFilter.val();
                        d.storage = storageFilter.val();
                        d.search  = searchInput.val();
                    },
                    error: function(xhr) {
                        console.error('AJAX Error, status:', xhr.status);
                        console.error('Response:', xhr.responseText);
                        alert('خطای سرور: لطفاً کنسول را چک کنید.');
                    }
                },
                // اضافه‌شده برای اسکرول عمودی با ارتفاع 500px
                scrollY:        '500px',
                scrollCollapse: true,
                paging:         true,   // اگر می‌خواهید صفحه‌بندی هم داشته باشد

                columns: [
                    {
                        data: 'id',
                        orderable: false,
                        searchable: false,
                        className: 'text-center',
                        render: function(data) {
                            return '<div class="form-check form-check-sm form-check-custom form-check-solid">' +
                                '  <input class="form-check-input" name="mobile_id" type="radio" value="' + data + '" />' +
                                '</div>';
                        }
                    },
                    {
                        data: null,
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return '' +
                                '<div class="d-flex align-items-center" ' +
                                '     data-kt-ecommerce-edit-order-filter="product" ' +
                                '     data-kt-ecommerce-edit-order-id="product_' + row.id + '">' +
                                '  <a class="symbol symbol-50px">' +
                                '    <span class="symbol-label" style="background-image:url(' + row.image_url + ');"></span>' +
                                '  </a>' +
                                '  <div class="ms-5">' +
                                '    <a class="text-gray-800 text-hover-primary fs-5 fw-bold">' + row.name + '</a>' +
                                '    <div class="text-muted fs-7">' + row.brand + '</div>' +
                                '  </div>' +
                                '</div>';
                        }
                    },
                    { data: 'ram',     title: 'رم',      orderable: false },
                    { data: 'storage', title: 'حافظه',  orderable: false }
                ],
                order: [[1, 'asc']],
                searchDelay: 500
            });

            brandFilter.add(ramFilter).add(storageFilter).on('change', function() {
                table.ajax.reload();
            });
            searchInput.on('input', function() {
                table.ajax.reload();
            });
        }
    };

    if (typeof KTUtil !== 'undefined') {
        KTUtil.onDOMContentLoaded(function() {
            KTProductSearch.init();
        });
    } else {
        document.addEventListener('DOMContentLoaded', KTProductSearch.init);
    }
    function hidden_off() {
        // اول رادیوی انتخاب‌شده رو بگیر
        const selected = document.querySelector('input[name="discount_option"]:checked');
        const offInput = document.getElementById('off_input');

        if (selected && selected.value === '1') {
            // اگر value برابر "2" بود، فیلد تخفیف رو نمایش بده
            offInput.classList.remove('hidden', 'fade');
        } else {
            // در غیر این صورت، مخفی‌ش کن
            offInput.classList.add('hidden', 'fade');
        }
    }


</script>
<!--end::Custom Javascript-->
<script>
    const api = new ApiClient();

    function create(){
        function collectData() {
            const data = {
                // محصول انتخاب‌شده (radio)
                mobile_id: (() => {
                    const el = document.querySelector('input[name="mobile_id"]:checked');
                    return el ? el.value : null;
                })(),

                // برند، رم، حافظه، نام جستجو
                brand:    document.querySelector('#brand222').value || null,
                ram:      document.querySelector('#ram').value      || null,
                storage:  document.querySelector('#storage').value  || null,
                product_search: document
                    .querySelector('input[data-kt-ecommerce-edit-order-filter="search"]')
                    .value.trim() || null,

                // قیمت پایه
                price:    document.querySelector('input[name="price"]').value.trim() || null,

                // تخفیف
                is_off: (() => {
                    const el = document.querySelector('input[name="discount_option"]:checked');
                    return el ? el.value : null;
                })(),
                off_percent: document.querySelector('input[name="off_pecent"]').value.trim() || null,
                date_off:    document.querySelector('input[name="date_off"]').value.trim()   || null,

                // رنگ محصول
                color_code: document.querySelector('input[name="color_code"]').value || null,

                // موجودی انبار
                count:      document.querySelector('input[name="count"]').value.trim() || null,
            };

            return data;
        }
        data = collectData();
        api.post("/api/create/vendor-mobile" , data).then(
            response => {
                console.log(response);
                if (response.message === "Success"){
                    console.log(response);
                    Swal.fire({
                        text: "محصول ساخته شد",
                        icon: "success",
                        confirmButtonText: "ادامه"
                    }).then(
                        () => {
                            // window.location.reload();
                        }
                    )
                }else{
                    Swal.fire({
                        text: "مشکلی در ارتباط با سرور وجود دارد",
                        icon: "error",
                        confirmButtonText: "ادامه"
                    });
                }
            }
        )
    }
</script>

<script>
        document.addEventListener('DOMContentLoaded', () => {
            const menu        = document.getElementById('colorDropdownMenu');
            const label       = document.getElementById('colorDropdownLabel');
            const swatch      = document.getElementById('colorDropdownSwatch');
            const hiddenInput = document.getElementById('color_code');

            // ۱. انتخاب رنگ موجود
            menu.querySelectorAll('.color-item').forEach(btn => {
                btn.addEventListener('click', () => {
                    const id   = btn.dataset.value;
                    const name = btn.dataset.name;
                    const hex  = btn.dataset.hex;

                    label.textContent       = name;
                    swatch.style.background = hex;
                    swatch.style.display    = 'inline-block';
                    hiddenInput.value       = id;

                    $('#customColorSection').collapse('hide');
                });
            });

            // ۲. باز/بسته‌کردن فرم custom
            document.getElementById('showCustomColor').addEventListener('click', e => {
                e.preventDefault();
                $('#customColorSection').collapse('toggle');
            });

            // ۳. ارسال رنگ custom با FormData
            document.getElementById('applyCustomColor').addEventListener('click', () => {
                const nameInput  = document.querySelector('#customColorName').value.trim();
                const textInput  = document.querySelector('#customColorText').value.trim();
                const pickerVal  = document.querySelector('#customColorPicker').value;
                const code       = textInput || pickerVal;

                if (!nameInput)  return alert('لطفاً نام رنگ را وارد کنید.');
                const isHex = /^#([0-9A-F]{3}){1,2}$/i.test(code);
                const isRgb = /^rgb\((\s*\d+\s*,){2}\s*\d+\s*\)$/i.test(code);
                if (!isHex && !isRgb) return alert('کد رنگ معتبر نیست.');

                const formData = new FormData();
                formData.append('name', nameInput);
                formData.append('code', code);

                fetch('/api/create/color', {
                    method: 'POST',
                    body: formData
                })
                    .then(r => r.json())
                    .then(res => {
                        if (res.status !== 'ok') throw new Error(res.message || 'خطا در سرور');

                        const newId = res.data.id;
                        // ساخت آیتم جدید
                        const btn = document.createElement('button');
                        btn.type = 'button';
                        btn.className = 'dropdown-item d-flex align-items-center color-item';
                        btn.dataset.value = newId;
                        btn.dataset.name  = nameInput;
                        btn.dataset.hex   = code;

                        const sw = document.createElement('span');
                        sw.className = 'color-swatch';
                        sw.style.background = code;
                        btn.appendChild(sw);
                        btn.appendChild(document.createTextNode(nameInput));

                        // افزودن قبل از divider
                        const divider = menu.querySelector('.dropdown-divider');
                        menu.insertBefore(btn, divider);

                        // انتخاب آن آیتم
                        label.textContent       = nameInput;
                        swatch.style.background = code;
                        swatch.style.display    = 'inline-block';
                        hiddenInput.value       = newId;

                        // attach event
                        btn.addEventListener('click', () => {
                            label.textContent       = nameInput;
                            swatch.style.background = code;
                            swatch.style.display    = 'inline-block';
                            hiddenInput.value       = newId;
                            $('#customColorSection').collapse('hide');
                        });

                        // reset
                        document.querySelector('#customColorName').value = '';
                        document.querySelector('#customColorText').value = '';
                        $('#customColorSection').collapse('hide');
                    })
                    .catch(err => {
                        console.error(err);
                        alert(err.message || 'خطا در افزودن رنگ جدید');
                    });
            });
        });
    </script>






    <!--end::Javascript-->
</body>
<!--end::Body-->
</html>