<?php 

function base_url(string $url){
    
    return $_ENV['BASE_URL'] . $url;

}
function view($path,$data = [])
{
    extract($data);
    include_once __DIR__ . "/../views/$path.php" ;
}
function hash_verify($password , $hash )
{
     return password_verify($password, $hash);

}
function hash_password($password)
{
    return password_hash($password, PASSWORD_BCRYPT, ['cost' => 10]);
}
function is_logged_in()
{
    session_start();
    if (isset($_SESSION["user"]) && !empty($_SESSION["user"])) {
        return true;
    }else {
        redirect("adminshop");
        return false;
    }
}
function redirect($url)
{
    $url = base_url($url);
    if (!headers_sent()){
        header("Location: $url");
    }else{
        echo "<script type='text/javascript'>window.location.href='$url'</script>";
        echo "<noscript><meta http-equiv='refresh' content='0;url=$url'/></noscript>";
    }
    exit;
}
function uploadFile($file) {
    $uploadsDir = __DIR__ . "/assets/inputs/";

    try {
        // بررسی وجود فایل
        if (!$file || $file['error'] !== UPLOAD_ERR_OK) {
            throw new Exception("خطا در آپلود فایل. کد خطا: " . $file['error']);
        }

        $fileName = basename($file['name']);
        $filePath = $uploadsDir . $fileName;
        $fileCount = 1;

        // بررسی وجود فایل با نام مشابه
        while (file_exists($filePath)) {
            $fileNameParts = pathinfo($fileName);
            $filePath = $uploadsDir . $fileNameParts['filename'] . "($fileCount)." . $fileNameParts['extension'];
            $fileCount++;
        }

        // جابجا کردن فایل آپلود شده به مسیر نهایی
        if (!move_uploaded_file($file['tmp_name'], $filePath)) {
            throw new Exception("جابجایی فایل ناموفق بود.");
        }

        return $filePath; // یا نام فایل را برگردانید
    } catch (Exception $e) {
        error_log("خطا در آپلود فایل: " . $e->getMessage());
        return null; // یا ارور خاصی برگردانید
    }
}
function this_time(){
    return date('Y-m-d H:i:s');
}
function shamsi($datetime) {
    // جدا کردن تاریخ و زمان
    if (explode(' ', $datetime)){
        list($date, $time) = explode(' ', $datetime);
    }else{
        $date = $datetime;
    }
    // چک کردن اگر تاریخ ورودی از قبل شمسی باشد (بررسی کنید که سال کمتر از 1500 است)
    $year = substr($date, 0, 4);
    if ((int)$year < 1500) {
        return $datetime; // اگر تاریخ شمسی است، همان را برگردانید
    }

    // ادامه عملیات تبدیل تاریخ میلادی به شمسی
    $dateParts = explode('-', $date);
    $gy = $dateParts[0];
    $gm = $dateParts[1];
    $gd = $dateParts[2];

    $mod = '-';
    $g_d_m = array(0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334);
    $gy2 = ($gm > 2) ? ($gy + 1) : $gy;
    $days = 355666 + (365 * $gy) + ((int)(($gy2 + 3) / 4)) - ((int)(($gy2 + 99) / 100)) + ((int)(($gy2 + 399) / 400)) + $gd + $g_d_m[$gm - 1];
    $jy = -1595 + (33 * ((int)($days / 12053)));
    $days %= 12053;
    $jy += 4 * ((int)($days / 1461));
    $days %= 1461;
    if ($days > 365) {
        $jy += (int)(($days - 1) / 365);
        $days = ($days - 1) % 365;
    }
    if ($days < 186) {
        $jm = 1 + (int)($days / 31);
        $jd = 1 + ($days % 31);
    } else {
        $jm = 7 + (int)(($days - 186) / 30);
        $jd = 1 + (($days - 186) % 30);
    }

    // ترکیب تاریخ شمسی با زمان اصلی
    return $jy . $mod . $jm . $mod . $jd . ' ' . $time;
}


function validateIranianNationalCode($code)
{
    // اضافه کردن صفر به کدهایی که کمتر از 10 رقم هستند
    $code = str_pad($code, 10, '0', STR_PAD_LEFT);

    // بررسی طول کد ملی
    if (strlen($code) != 10 || !preg_match('/^\d{10}$/', $code)) {
        return false;
    }

    // بررسی اینکه همه ارقام یکسان نباشند
    if (preg_match('/^(\d)\1{9}$/', $code)) {
        return false;
    }

    // محاسبه مجموع وزن‌دار
    $sum = 0;
    for ($i = 0; $i < 9; $i++) {
        $sum += (int) $code[$i] * (10 - $i);
    }

    // محاسبه باقی‌مانده و بررسی رقم کنترلی
    $remainder = $sum % 11;
    $controlDigit = (int) $code[9];
    if ($remainder < 2 && $controlDigit == $remainder || $remainder >= 2 && $controlDigit == 11 - $remainder) {
        return true;
    }

    return false;
}

function formatInterval($interval) {
    $months = $interval->m;
    $days = $interval->d;

    $formatted = '';

    if ($interval->y > 0) {
        $formatted .= $interval->y . ' سال ';
    }
    if ($months > 0) {
        $formatted .= $months . ' ماه ';
    }
    if ($days > 0) {
        $formatted .= $days . ' روز ';
    }

    if ($formatted === '') {
        $formatted = '0 روز';
    }

    return $formatted;
}
function convertNumber($string) {
    $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $arabic = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];

    $num = range(0, 9);
    $convertedPersianNums = str_replace($persian, $num, $string);
    $englishNumbersOnly = str_replace($arabic, $num, $convertedPersianNums);

    return $englishNumbersOnly;
}
function calculateDaysBetweenDates($date1, $date2) {
    $dateParts = explode('/', $date1);
    if (count($dateParts) == 3) {
        list($year, $month, $day) = $dateParts;
        $date1 = (int)convertNumber($year) . "-" . (int)convertNumber($month) . "-" . (int)convertNumber($day) ;
        $date2 = shamsi($date2);
    }
    $datetime2 = new DateTime($date1);
    $datetime1 = new DateTime($date2);
    $interval = $datetime1->diff($datetime2);
    return formatInterval($interval);
}
function timeAgo($datetime1, $datetime2) {
    $diff = abs(strtotime($datetime2) - strtotime($datetime1));

    if ($diff < 60) {
        return "الان";
    } elseif ($diff < 3600) {
        $minutes = round($diff / 60);
        return "$minutes دقیقه پیش";
    } elseif ($diff < 86400) {
        $hours = round($diff / 3600);
        return "$hours ساعت پیش";
    } elseif ($diff < 604800) {
        $days = round($diff / 86400);
        return "$days روز پیش";
    } else {
        $weeks = round($diff / 604800);
        return "$weeks هفته پیش";
    }
}
function translateField($field) {
    // بررسی و ترجمه نام فیلد
    switch ($field) {
        case 'id':
            return 'شناسه';
        case 'serial':
            return 'سریال';
        case 'serial_id':
            return 'شناسه سریال';
        case 'user_id':
            return 'شناسه کاربر';
        case 'customer_id':
            return 'شناسه مشتری';
        case 'activation_start_date':
            return 'تاریخ شروع فعالسازی';
        case 'guarantee_status':
            return 'وضعیت ضمانت';
        case 'problem':
            return 'مشکل';
        case 'situation':
            return 'وضعیت';
        case 'accessories':
            return 'لوازم جانبی';
        case 'dex':
            return 'توضیحات';
        case 'estimated_time':
            return 'زمان تخمینی';
        case 'estimated_cost':
            return 'هزینه تخمینی';
        case 'product_status':
            return 'وضعیت پذیرش';
        case 'paziresh_status':
            return 'وضعیت محصول';
        case 'file1':
            return 'فایل ۱';
        case 'file2':
            return 'فایل ۲';
        case 'file3':
            return 'فایل ۳';
        case 'file4':
            return 'فایل ۴';
        case 'file5':
            return 'فایل ۵';
        case 'file6':
            return 'فایل ۶';
        case 'kaar':
            return 'کار انجام شده';
        case 'kaar_serial':
            return 'سریال قطعه تعویضی';
        case 'kaar_at':
            return 'تاریخ کار';
        case 'sh_baar':
            return 'شماره بارنامه ارسال به مرکز';
        case 'sh_baar2':
            return 'شماره بارنامه ارسال به نماینده';
        case 'ersal_agent_b_daftar_at':
            return 'ارسال به دفتر از تاریخ';
        case 'driaft_daftar_az_agent_at':
            return 'دریافت دفتر از تاریخ';
        case 'ersal_daftar_b_agent_at':
            return 'ارسال دفتر به نماینده از تاریخ';
        case 'driaft_agent_az_daftar_at':
            return 'دریافت نماینده از دفتر از تاریخ';
        case 'driaf_moshtari_at':
            return 'دریافت مشتری از تاریخ';
        case 'created_at':
            return 'تاریخ ایجاد';
        case 'updated_at':
            return 'تاریخ بروزرسانی';
        default:
            return $field; // در صورتی که نام فیلد شناخته نشده باشد
    }
}
function jalali_to_gregorian_string($jalali_date) {
    // تبدیل اعداد فارسی به انگلیسی
    $jalali_date = convert_farsi_numbers($jalali_date);

    // جدا کردن سال، ماه و روز از رشته
    list($jy, $jm, $jd) = explode('/', $jalali_date);

    // تبدیل به اعداد صحیح
    $jy = (int) $jy;
    $jm = (int) $jm;
    $jd = (int) $jd;

    // تبدیل تاریخ شمسی به میلادی
    list($gy, $gm, $gd) = jalali_to_gregorian($jy, $jm, $jd);

    // بازگرداندن تاریخ میلادی در فرمت استاندارد YYYY-MM-DD
    return sprintf('%04d-%02d-%02d', $gy, $gm, $gd);
}

// تابع تبدیل اعداد فارسی به انگلیسی
function convert_farsi_numbers($string) {
    $persian_numbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $english_numbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    return str_replace($persian_numbers, $english_numbers, $string);
}

// تابع دقیق تبدیل شمسی به میلادی
function jalali_to_gregorian($jy, $jm, $jd) {
    $jy += 1595;
    $days = -355668 + (365 * $jy) + (((int)($jy / 33)) * 8) + ((int)(((($jy % 33) + 3) / 4)));
    $j_days_in_month = [31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29];

    for ($i = 0; $i < ($jm - 1); ++$i) {
        $days += $j_days_in_month[$i];
    }

    $days += $jd;
    $gy = 400 * (int)($days / 146097);
    $days %= 146097;

    if ($days > 36524) {
        $gy += 100 * (int)(--$days / 36524);
        $days %= 36524;
        if ($days >= 365) $days++;
    }

    $gy += 4 * (int)($days / 1461);
    $days %= 1461;

    if ($days > 365) {
        $gy += (int)(($days - 1) / 365);
        $days = ($days - 1) % 365;
    }

    $g_days_in_month = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    for ($i = 0; $days >= ($g_days_in_month[$i] + ($i == 1 && (($gy % 4 == 0 && $gy % 100 != 0) || ($gy % 400 == 0)))); $i++) {
        $days -= $g_days_in_month[$i] + ($i == 1 && (($gy % 4 == 0 && $gy % 100 != 0) || ($gy % 400 == 0)));
    }

    return [$gy, $i + 1, $days + 1];
}
function create_random_code()
{
    return str_pad(mt_rand(0, 9999), 4, '0', STR_PAD_LEFT);
}
