"use strict";
var KTProjectUsers = {
    init: function() {
        !function() {
            const t = document.getElementById("serials_list");
            if (!t) return;

            // Initialize DataTable
            const e = $(t).DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: 'https://mobilerepair.ir/api/serials/all',
                    type: 'GET',
                    data: function(d) {
                        // Add custom parameter for search
                        d.serials = $('#serial').val(); // گرفتن مقدار اینپوت
                    }
                },
                columns: [
                    { data: 'serial', title: 'سریال' },
                    { data: 'added_by_user', title: 'توسط یوزر' },
                    { data: 'approved', title: 'وضعیت' },
                    { data: 'title', title: 'عنوان محصول' },
                    { data: 'model', title: 'مدل' },
                    { data: 'created_at', title: 'تاریخ ثبت' },
                    { data: 'agent_service', title: 'شماره سند' },
                    { data: 'company', title: 'شرکت وارد کننده' },
                    { data: 'action', orderable: false, title: 'اقدام' }
                ],
                order: [],
                columnDefs: [{
                    targets: 4,
                    orderable: !1
                }]
            });

            // Custom Search
            $('#serial').on('input', function() {
                e.ajax.reload(); // Reload table with custom parameter
            });
        }()
    }
};

KTUtil.onDOMContentLoaded(function() {
    KTProjectUsers.init();
});
