<?php

namespace App\Utilities;

use App\Repositories\CardItemRepository;
use App\Repositories\CardRepository;
use App\Repositories\MobileRepository;
use App\Repositories\VendorMobileRepository;

class CardItems
{

    public function getCard($user_id)
    {
        $rcard = new CardRepository();
        $rcardItem = new CardItemRepository();
        $vmobile = new VendorMobileRepository();
        $mobile = new MobileRepository();
        if ($user_id==null or empty($user_id) or !isset($user_id)){
            return false;
        }else{
            $Card = $rcard->findByUserActive($user_id);
            if (empty($Card) or count($Card)<1){
                return false ;
            }else{
                $Card = $Card[0];
                $data = [];
                $cards = $rcardItem->findByCard($Card["id"]);
                foreach ($cards as $card){
                    $vedata = $vmobile->findById($card["vendor_mobile_id"]) ;
                    $mobile_id = $vedata["mobile_id"];
                    $mdata = $mobile->findById($mobile_id);
                    $data[] = [
                        "cardData" => $card,
                        "mData" => $mdata,
                        "vdata" => $vedata
                    ];
                }
                return $data ;
            }
        }
    }
}