<?php

namespace App\Repositories;

use App\Repositories\BrandRepository;
use App\Repositories\ColorRepository;
use App\Repositories\MobileRepository;
use App\Repositories\MobileImageRepository;
use App\Repositories\VendorMobileRepository;


class activeMobile
{

    public function get($query = null ,$limit = null ,$offset = null){
        $mobile     = new MobileRepository();
        $vmobile = new VendorMobileRepository();
        $brand = new BrandRepository();
        try {
            $mobiles = $mobile->ActiveMobile($query, $limit, $offset);
            $data = [];
            foreach ($mobiles as $d) {
                $brandName = $brand->findById($d["brand_id"])["name"];
                $vdata = $vmobile->findByMobile($d["id"])[0];
                $activePrice = $vdata["price"] - ($vdata["price"] * $vdata["off_persent"] / 100);
                $pdata = [
                    "active_price" =>number_format($activePrice),
                    'price' =>  number_format($vdata["price"]),
                    'is_off' => $vdata["is_off"],
                    'off_persent' => $vdata["off_persent"],
                ];
                $data[] = array_merge($d, $pdata);
            }
            return $data ;
        }catch (\Exception $e) {
            return null;
        }
    }
    public function find($query = null){
        $mobile     = new MobileRepository();
        $vmobile = new VendorMobileRepository();
        $brand = new BrandRepository();
        try {
            $mobiles = $mobile->ActiveMobile($query);
            $data = [];
            foreach ($mobiles as $d) {
                $brandName = $brand->findById($d["brand_id"])["name"];
                $vdata = $vmobile->findByMobile($d["id"])[0];
                $activePrice = $vdata["price"] - ($vdata["price"] * $vdata["off_persent"] / 100);
                $pdata = [
                    'price' => number_format($activePrice),
                    'is_off' => $vdata["is_off"],
                    'off_persent' => $vdata["off_persent"],
                ];
                $data[] = array_merge($d, $pdata);
            }
            return $data[0] ;
        }catch (\Exception $e) {
            return null;
        }
    }
}