<?php
namespace App\Repositories;

class MobileRepository extends BaseRepository
{
    protected string $table = 'mobiles';

    public function findByBrand(int $brandId, int $limit = null, int $offset = null): array
    {
        $sql = "SELECT * FROM `{$this->table}` WHERE `brand_id` = :bid ORDER BY `id` DESC";
        $params = ['bid' => $brandId];
        if (isset($limit, $offset)) {
            $sql .= " LIMIT $limit OFFSET $offset";
        }
        return $this->db->select($sql, $params);
    }

    public function ActiveMobile($querys = null, $limit = null, $offset = null): array
    {
        $sql = "SELECT * FROM `{$this->table}`  WHERE `is_vendor` = 1 AND ";
        if (isset($querys) and !empty($querys)) {
            $count = count($querys);
            foreach ($querys as $key => $value) {
                $count = $count - 1;
                if ($count == 0) {
                    $sql .= " $key = $value ";
                } else {
                    $sql .= " `$key` = `$value` OR ";
                }
            }
        } else {
            $sql .= "1 ORDER BY id DESC ";
        }
        if (isset($limit) and isset($offset) and $limit>=0 and $offset>=0) {

            $sql .= "  LIMIT $limit OFFSET $offset";
        }
        return $this->db->select($sql);
    }
    public function getRams(){
            return $this->db->select("SELECT DISTINCT `ram` FROM `{$this->table}`  WHERE `deleted_at` IS NULL AND `is_active` = 1 AND `ram` IS NOT NULL");
    }
    public function getStorage(){
        return $this->db->select("SELECT DISTINCT `storage` FROM `{$this->table}`  WHERE `deleted_at` IS NULL AND `is_active` = 1 AND `storage` IS NOT NULL");
    }


}
