<?php
namespace App\Repositories;

class CardRepository extends BaseRepository
{
    protected string $table = 'cards';

    public function findByUser(int $userId): array
    {
        return $this->db->select(
            "SELECT * FROM `{$this->table}` WHERE `user_id` = :uid ORDER BY `id` DESC",
            ['uid' => $userId]
        );
    }
    public function findByUserActive(int $userId): array
    {
        return $this->db->select(
            "SELECT * FROM `{$this->table}` WHERE `user_id` = :uid AND `status` = :pending ORDER BY `id` DESC",
            ['uid' => $userId,"pending"=> "pending"]
        );
    }


}
