<?php
namespace App\Repositories;

class CardItemRepository extends BaseRepository
{
    protected string $table = 'card_items';

    public function findByCard(int $cardId): array
    {
        return $this->db->select(
            "SELECT * FROM `{$this->table}` WHERE `card_id` = :cid",
            ['cid' => $cardId]
        );
    }
    public function findByMobile(int $cardId , int $mid): array
    {
        return $this->db->select(
            "SELECT * FROM `{$this->table}` WHERE `card_id` = :cid AND `vendor_mobile_id` = :mid",
            ['cid' => $cardId , "mid"=> $mid]
        );
    }
}
