<?php

namespace App\Core\Validator;
use App\Core\Response\Response;

class Validator
{
    private $errors = [];
    private $response;

    public function __construct()
    {
        $this->response = new Response();
    }

    // متد validate که داده و قوانین را می‌گیرد
    public function validate(array $data, array $rules)
    {
        foreach ($rules as $field => $ruleSet) {
            foreach ($ruleSet as $rule) {
                // بررسی اختیاری بودن فیلد
                if (strpos($rule, 'optional') !== false && (!isset($data[$field]) || trim($data[$field]) === '')) {
                    continue;
                }
                // اجرای قوانین
                if (method_exists($this, $rule)) {
                    $this->$rule($field, $data[$field] ?? null);
                }
            }
        }
        if (!empty($this->errors)) {
            // اگر خطا وجود داشت، پاسخ مناسب برگردانده شود
            $this->response
                ->badRequest('Validation Failed')
                ->setBody(['errors' => $this->getErrors()])
                ->respond();
        }
        return true; // اگر هیچ خطایی نبود
    }

    // متد افزودن خطا
    private function addError($field, $message)
    {
        $this->errors[$field][] = $message;
    }

    // دریافت خطاها
    public function getErrors()
    {
        return $this->errors;
    }

    // قانون required
    private function required($field, $value)
    {
        if (is_null($value) || trim($value) === '') {
            $this->addError($field, "$field is required.");
        }
    }

    // قانون email
    private function email($field, $value)
    {
        if (!filter_var($value, FILTER_VALIDATE_EMAIL)) {
            $this->addError($field, "$field must be a valid email.");
        }
    }

    // قانون numeric
    private function numeric($field, $value)
    {
        if (!is_numeric($value)) {
            $this->addError($field, "$field must be a number.");
        }
    }

    // قانون string
    private function string($field, $value)
    {
        if (!is_string($value)) {
            $this->addError($field, "$field must be a string.");
        }
    }

    // قانون optional (مخصوص فیلدهای اختیاری)
    private function optional($field, $value)
    {
        // این قانون تنها برای اختیاری بودن استفاده می‌شود و در validate مدیریت می‌شود
    }
}
//$validator = new Validator();
//
//// داده‌های ورودی
//$data = [
//    'name' => 'John Doe',
//    'email' => 'invalid-email',
//    'age' => 'twenty',
//];
//
//// قوانین ولیدیشن
//$rules = [
//    'name' => ['required', 'string'],
//    'email' => ['required', 'email'],
//    'age' => ['optional', 'numeric'],
//];
//
//// اجرای ولیدیشن
//$validator->validate($data, $rules);
//
//// اگر ولیدیشن موفق بود
//(new Response())
//    ->ok($data, 'All data is valid.')
//    ->respond();
