<?php 
namespace App\Core\Routing;

class Route
{
    private static $routes = [];
    public static function add($methods , $uri , $action = null , $Middleware = [] ){

        $methods = is_array($methods) ? $methods : [$methods];
        self::$routes[] = [
            'methods' => $methods,
            'uri' => $uri,
            'action' => $action,
            "Middleware" => $Middleware
        ];   
    }
    public static function get($uri , $action = null, $Middleware = []){
        self::add('GET' , $uri , $action ,$Middleware);
    }

    public static function post($uri , $action = null, $Middleware = []){
        self::add('POST' , $uri , $action,$Middleware);
    }

    public static function put($uri , $action = null, $Middleware = []){
        self::add('PUT' , $uri , $action,$Middleware);
    }

    public static function delete($uri , $action = null, $Middleware = []){
        self::add('DELETE' , $uri , $action,$Middleware);
    }

    public static function patch($methods , $uri , $action = null, $Middleware = []){
        self::add("patch" , $uri , $action,$Middleware);
    }

    public static function options($methods , $uri , $action = null, $Middleware = []){
        self::add("options" , $uri , $action,$Middleware);
    }
    
    public static function routes(){
        return self::$routes;
    }
}