<?php

namespace App\Core\Response;

class Response
{
    private $statusCode;
    private $headers;
    private $body;

    public function __construct()
    {
        $this->statusCode = 200; // پیش‌فرض
        $this->headers = ['Content-Type' => 'application/json'];
        $this->setHeaders(["charset=UTF-8"]);
        $this->body = [];
    }

    public function setHeaders(array $headers)
    {
        $this->headers = array_merge($this->headers, $headers);
        return $this;
    }

    public function setStatusCode($statusCode)
    {
        $this->statusCode = $statusCode;
        return $this;
    }

    public function setBody($body)
    {
        $this->body = $body;
        return $this;
    }
    public function csvResponse($csvContent, $filename = 'export.csv')
    {
        $this->setHeaders([
            'Content-Type' => 'text/csv; charset=utf-8',
            'Content-Disposition' => 'attachment; filename="' . $filename . '"'
        ]);

        $this->setBody($csvContent);
        return $this;
    }

    public function respond($isBinary = false)
    {
        // Set headers
        foreach ($this->headers as $name => $value) {
            header("$name: $value");
        }

        // Set status code
        http_response_code($this->statusCode);

        // Output body
        if ($isBinary) {
            // چاپ محتوای باینری به‌صورت مستقیم (مانند CSV)
            echo $this->body;
        } else {
            echo json_encode($this->body);
        }
        exit;
    }

    public function ok($data = [], $message = 'Success')
    {
        $this->setStatusCode(200);
        $this->setBody(['status' => 'success', 'message' => $message, 'data' => $data]);
        return $this;
    }

    public function created($data = [], $message = 'Resource created')
    {
        $this->setStatusCode(201);
        $this->setBody(['status' => 'success', 'message' => $message, 'data' => $data]);
        return $this;
    }

    public function badRequest($message = 'Bad Request', $data = [])
    {
        $this->setStatusCode(400);
        $this->setBody(['status' => 'error', 'message' => $message, 'data' => $data]);
        return $this;
    }

    public function notFound($message = 'Not Found', $data = [])
    {
        $this->setStatusCode(404);
        $this->setBody(['status' => 'error', 'message' => $message, 'data' => $data]);
        return $this;
    }

    public function serverError($message = 'Internal Server Error', $data = [])
    {
        $this->setStatusCode(500);
        $this->setBody(['status' => 'error', 'message' => $message, 'data' => $data]);
        return $this;
    }
    public function notAcceptable($message = 'Not Acceptable', $data = [])
    {
        $this->setStatusCode(406);
        $this->setBody(['status' => 'error', 'message' => $message, 'data' => $data]);
        return $this;
    }

}

// استفاده از کلاس Response
//// ارسال پاسخ موفقیت‌آمیز
//$response = (new Response())->ok(['item1', 'item2'], 'Data retrieved successfully');
//$response->respond();
//
//// ارسال پاسخ برای درخواست نامعتبر
//$response = (new Response())->badRequest('Invalid parameters', ['errors' => ['field' => 'error']]);
//$response->respond();
//
//// ارسال پاسخ برای منبع یافت نشد
//$response = (new Response())->notFound('Resource not found');
//$response->respond();
//
//// ارسال پاسخ برای خطای سرور داخلی
//$response = (new Response())->serverError('Unexpected error occurred');
//$response->respond();


