<?php

namespace App\Controllers;

use App\Core\Http\Request;
use App\Repositories\activeMobile;
use App\Repositories\BrandRepository;
use App\Repositories\ColorRepository;
use App\Repositories\VendorMobileRepository;
use App\Repositories\VendorRepository;
use App\Utilities\CardItems;
use http\Env\Response;
use MongoDB\Driver\Session;

class Site
{
    public function  home(){
        session_start();
        $mobiles = new activeMobile();
        $cards = new CardItems();
        $data = [
          "mobiles1"=> $mobiles->get(null , 6, 0),
          "mobiles2" => $mobiles->get(),
          "cards" => $cards->getCard($_SESSION["user"]["id"]??null)
        ];
        view("site/home", $data );
    }

    public function shop()
    {
        session_start();
        $request = new Request();
        $cards = new CardItems();
        $data = [
            "cards" => $cards->getCard($_SESSION["user"]["id"]??null)
        ];
        view("site/shop",$data);
    }
    public function product() {
        session_start();
        $request = new Request();
        $mobiles = new activeMobile();
        $vendor = new VendorRepository();
        $vendorMobile = new VendorMobileRepository();
        $col = new ColorRepository();
        $brand = new BrandRepository();
        $cards = new CardItems();
        $id = $request::input("id");
        $vData = $vendorMobile->findByMobile($id);
        $vMobile=[];
        foreach ($vData as $ve) {
            $ven = $vendor->findById($ve["vendor_id"]);
            $vMobile[] = [
                "name"=>$ven["name"],
                "id" =>$ve["id"],
                "vendor_name"=>$ven["vendor_name"],
                "price" => number_format($ve["price"]),
                "is_off" => $ve["is_off"],
                "off_persent" => $ve["off_persent"],
                "pic" => $ven["pic"]
            ];
        }
        $mobile = $mobiles->find(["id" => $id]);
        $detail = json_decode($mobile["detail"],true);
        $colors = explode(",",$mobile["color_id"]);
        $colorData = [] ;
        foreach ($colors as $color) {
            $colorData[] = $col->findById($color);
        }
        $brand2 = $brand->findById($mobile["brand_id"]);
        $data = [
            "mobile" => $mobiles->find(["id" => $id]),
            "brand" => $brand2["name"],
            "vendors" => $vMobile,
            "detail" => $detail,
            "colors" => $colorData,
            "mobiles2"=> $mobiles->get(null , 6, 0),
            "cards" => $cards->getCard($_SESSION["user"]["id"]??null)
        ];
        view("site/product", $data);
    }
    public function about()
    {
        session_start();
        $request = new Request();
        $cards = new CardItems();
        $data = [
            "cards" => $cards->getCard($_SESSION["user"]["id"]??null)
        ];
        view("site/about",$data);
    }
    public function roles()
    {
        session_start();
        $request = new Request();
        $cards = new CardItems();
        $data = [
            "cards" => $cards->getCard($_SESSION["user"]["id"]??null)
        ];
        view("site/roles",$data);
    }
    public function Carts()
    {
        session_start();
        $request = new Request();
        $cards = new CardItems();
        $data = [
            "cards" => $cards->getCard($_SESSION["user"]["id"]??null)
        ];
        view("site/carts", $data);
    }

}